/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.AABuilder;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.IVarIndex;
import org.beetl.core.statement.VarAttribute;
import org.beetl.core.statement.VarRef;
import org.beetl.core.statement.VarSquareAttribute;

public class VarRefAssignExpress
extends Expression
implements IVarIndex {
    public Expression exp;
    public VarRef varRef;
    protected VarAttribute lastVarAttribute = null;
    protected int varIndex = -1;

    public VarRefAssignExpress(Expression exp, VarRef varRef) {
        super(varRef.token);
        this.exp = exp;
        this.varRef = varRef;
        this.lastVarAttribute = varRef.attributes.length == 0 ? null : varRef.attributes[varRef.attributes.length - 1];
    }

    @Override
    public Object evaluate(Context ctx) {
        Object value = this.exp.evaluate(ctx);
        if (this.lastVarAttribute == null) {
            ctx.vars[this.varIndex] = value;
            return value;
        }
        Object obj = this.varRef.evaluateUntilLast(ctx);
        Object key = null;
        key = this.lastVarAttribute instanceof VarSquareAttribute ? ((VarSquareAttribute)this.lastVarAttribute).exp.evaluate(ctx) : this.lastVarAttribute.name;
        if (obj == null) {
            BeetlException bx = new BeetlException("NULL");
            bx.pushToken(this.varRef.token);
            throw bx;
        }
        try {
            AttributeAccess aa = AABuilder.buildFiledAccessor(obj.getClass());
            aa.setValue(obj, key, value);
            return value;
        }
        catch (ClassCastException ex) {
            BeetlException bx = new BeetlException("ATTRIBUTE_INVALID", ex);
            bx.pushToken(this.lastVarAttribute.token);
            throw bx;
        }
        catch (BeetlException be) {
            be.pushToken(this.lastVarAttribute.token);
            throw be;
        }
    }

    @Override
    public void setVarIndex(int index) {
        this.varIndex = index;
    }

    @Override
    public int getVarIndex() {
        return this.varIndex;
    }
}

