/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm;

import com.informix.csm.IfxCsmReadBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IfxCsmBuffer
extends ByteArrayOutputStream {
    private static int DEFAULT_BUFF_SIZE = 128;

    public IfxCsmBuffer() {
        super(DEFAULT_BUFF_SIZE);
    }

    public IfxCsmBuffer(int initSize) {
        super(initSize);
    }

    public void initialize(IfxCsmBuffer anotherBuffer) {
        this.buf = anotherBuffer.buf;
        this.count = anotherBuffer.count;
        anotherBuffer.reset();
    }

    public void initialize(IfxCsmReadBuffer bis) {
        this.buf = bis.getBuf();
        this.count = bis.getCount();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        super.write(b, off, len);
    }

    @Override
    public synchronized void write(byte[] b) {
        super.write(b, 0, b.length);
    }

    public synchronized void resetAndwrite(byte[] b) {
        super.reset();
        super.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(int b) {
        super.write(b);
    }

    @Override
    public synchronized byte[] toByteArray() {
        return super.toByteArray();
    }

    public synchronized byte[] toByteArrayWithReset() {
        byte[] retVal = super.toByteArray();
        super.reset();
        return retVal;
    }

    public synchronized int read(byte[] b, int off, int len) {
        int numBytesCopied = -1;
        if (this.count == 0) {
            return 0;
        }
        numBytesCopied = len > this.count ? this.count : len;
        System.arraycopy(this.buf, 0, b, off, numBytesCopied);
        return numBytesCopied;
    }

    public synchronized byte[] read(int len) {
        byte[] ret = new byte[len];
        this.read(ret, 0, ret.length);
        return ret;
    }

    public synchronized byte[] readWithReset(int len) {
        byte[] ret = new byte[len];
        this.readWithReset(ret, 0, len);
        return ret;
    }

    public synchronized int readWithReset(byte[] b, int off, int len) {
        int numBytesCopied = this.read(b, off, len);
        if (numBytesCopied == -1) {
            return numBytesCopied;
        }
        byte[] currArray = super.toByteArray();
        byte[] newBuf = new byte[this.count - numBytesCopied];
        System.arraycopy(this.buf, numBytesCopied, newBuf, 0, newBuf.length);
        this.buf = newBuf;
        this.count -= numBytesCopied;
        return numBytesCopied;
    }

    public synchronized int getCount() {
        return this.count;
    }

    synchronized byte[] getBuf() {
        return this.buf;
    }

    @Override
    public void reset() {
        this.count = 0;
        this.buf = new byte[DEFAULT_BUFF_SIZE];
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        super.writeTo(out);
    }
}

