/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.TraceFlag;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class IfxBigInt
extends IfxObject {
    private long value;
    public static final long IFX_BIGINT_NULL = Long.MIN_VALUE;

    IfxBigInt() throws SQLException {
        this.setIfxType(52);
    }

    IfxBigInt(long l) throws SQLException {
        this.setIfxType(52);
        this.value = l;
        this.unnullify();
    }

    IfxBigInt(Long L) throws SQLException {
        this.setIfxType(52);
        this.value = L;
        this.unnullify();
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxLongBigInt(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[8];
            b[0] = -128;
            return b;
        }
        return JavaToIfxType.JavaToIfxLongBigInt(this.value);
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Long(this.value);
    }

    @Override
    public void fromIfx(byte[] b) {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) {
        this.value = IfxToJavaType.IfxToJavaLongBigInt(b, offset);
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(3, "IfxBigInt: fromIfx = " + this.value);
        }
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public void fromByte(byte val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value;
    }

    @Override
    public void fromShort(short val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (int)this.value;
    }

    @Override
    public void fromInt(int val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    public void fromShort(Integer val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    @Override
    public void fromLong(long val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromLong(Long val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val;
            this.unnullify();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(float val) throws SQLException {
        this.value = (long)val;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double val) throws SQLException {
        this.value = (long)val;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(Long.toString(this.value));
    }

    @Override
    public void fromDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0L;
    }

    public void fromBigInt(BigInteger i) throws SQLException {
        this.fromLong(i.longValue());
    }

    public BigInteger toBigInt() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public void fromBoolean(boolean val) throws SQLException {
        this.value = val ? 1 : 0;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val == true ? 1 : 0;
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.value);
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            this.value = Long.valueOf(str.trim());
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxBigInt && this.value == ((IfxBigInt)other).value;
    }

    @Override
    public short getEncodedLength() {
        short encodedLength = 4864;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(3, "IfxBigInt ecodedLength = " + encodedLength);
        }
        return encodedLength;
    }

    public boolean isIfxNull() {
        return this.value == Long.MIN_VALUE;
    }
}

