/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.IfxToJavaType;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import com.informix.util.dateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

public class IfxChar
extends IfxObject {
    private String value;
    private String valueTrimmed;
    private String trailing_trimmed;
    private static int char_MaxLength = 65534;

    public IfxChar() throws SQLException {
        this.setIfxType(0);
    }

    public IfxChar(char[] c) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(3, "IfxChar(char[] c) constructor called, c = " + new String(c));
        }
        this.setIfxType(0);
        try {
            this.value = new String(c);
            if (this.value == null) {
                this.nullify();
            } else {
                this.unnullify();
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79702, this.conn);
        }
    }

    public IfxChar(String S) throws SQLException {
        this.setIfxType(0);
        if (S != null) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(3, "IfxChar(String) constructor called, c = " + S);
            }
            this.trimIfxChar(S);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null || !(other instanceof IfxChar)) {
            return false;
        }
        IfxChar otherChar = (IfxChar)other;
        if (otherChar.isNull()) {
            return false;
        }
        return this.value.equals(otherChar.value);
    }

    @Override
    public byte[] toIfx() throws SQLException {
        try {
            if (this.isNull()) {
                return null;
            }
            return ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, this.conn.getdbEncoding(), ((IfxSqliConnect)this.conn).encoption);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        try {
            short len;
            if (this.isNull()) {
                byte[] b = new byte[this.getEncodedLength()];
                Arrays.fill(b, (byte)32);
                b[0] = 0;
                return b;
            }
            byte[] b = null;
            String dbEnc = this.conn.getdbEncoding();
            b = dbEnc != null ? this.value.getBytes(dbEnc) : this.value.getBytes();
            if (b.length > (len = this.getEncodedLength())) {
                byte[] temp = new byte[len];
                System.arraycopy(b, 0, temp, 0, len);
                return temp;
            }
            return b;
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromIfx(byte[] b) throws SQLException {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) throws SQLException {
        try {
            if (b == null || b[offset] == 0) {
                this.nullify();
                return;
            }
            String dbEnc = this.conn.getdbEncoding();
            if (((IfxSqliConnect)this.conn).isOnLine5SER()) {
                dbEnc = "NOENCODING";
            }
            this.value = IfxToJavaType.IfxToJavaChar(b, offset, length, dbEnc, ((IfxSqliConnect)this.conn).encoption);
            if (this.conn != null && this.conn.getTrimTrailingSpaces()) {
                this.trimIfxChar(this.value);
                this.value = this.trailing_trimmed;
            } else if (this.value == null) {
                this.nullify();
            } else {
                this.unnullify();
            }
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(3, "IfxChar.fromIfx(): value - " + this.value + ", b.length" + length);
            }
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxChar.fromString() called");
        }
        if (str == null) {
            this.nullify();
        } else {
            this.trimIfxChar(str);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxChar.fromString() exited");
        }
    }

    @Override
    public void fromBytes(byte[] str) throws SQLException {
        block6: {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(99, "IfxChar.fromBytes() called");
            }
            if (str == null) {
                this.nullify();
            } else {
                try {
                    String dbEnc = this.conn.getdbEncoding();
                    this.value = IfxToJavaType.IfxToJavaChar(str, 0, str.length, dbEnc, ((IfxSqliConnect)this.conn).encoption);
                    this.trimIfxChar(this.value);
                }
                catch (Exception e) {
                    this.value = null;
                    if (!(e instanceof IOException)) break block6;
                    throw IfxErrMsg.getSQLException(-79783, this.conn);
                }
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxChar.fromBytes() exited");
        }
    }

    @Override
    public int toInt() throws SQLException {
        int i = 0;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                i = Integer.parseInt(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return i;
    }

    @Override
    public void fromInt(int i) throws SQLException {
        this.value = Integer.toString(i);
        this.unnullify();
    }

    @Override
    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.nullify();
        } else {
            this.value = I.toString();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigD;
        if (this.isNull()) {
            return null;
        }
        try {
            this.trimIfxChar(this.value);
            bigD = new BigDecimal(this.valueTrimmed);
        }
        catch (NumberFormatException e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return bigD;
    }

    @Override
    public void fromDecimal(BigDecimal B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.toString();
            this.unnullify();
        }
    }

    @Override
    public byte toByte() throws SQLException {
        byte b = 0;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                b = Byte.parseByte(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return b;
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxChar.toBytes() called");
        }
        byte[] b = null;
        if (this.value == null) {
            this.nullify();
        } else {
            try {
                String cliEnc = ((IfxSqliConnect)this.conn).returnEnc();
                byte[] temp = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, cliEnc, ((IfxSqliConnect)this.conn).encoption);
                int x = temp.length;
                b = new byte[x - 2];
                System.arraycopy(temp, 2, b, 0, x - 2);
            }
            catch (Exception e) {
                this.value = null;
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxChar.toBytes() exited");
        }
        return b;
    }

    @Override
    public void fromByte(byte b) throws SQLException {
        this.value = Byte.toString(b);
        this.unnullify();
    }

    @Override
    public void fromByte(Byte B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.toString();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        this.trimIfxChar(this.value);
        return this.valueTrimmed.equalsIgnoreCase("t") || this.valueTrimmed.equalsIgnoreCase("1") || this.valueTrimmed.equalsIgnoreCase("true");
    }

    @Override
    public void fromBoolean(boolean b) throws SQLException {
        this.value = String.valueOf(b);
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.toString();
            this.unnullify();
        }
    }

    @Override
    public Date toDate() throws SQLException {
        Date D = null;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                D = dateUtil.convertDateObj(this.valueTrimmed, this.conn);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return D;
    }

    @Override
    public void fromDate(Date D) throws SQLException {
        if (D == null) {
            this.nullify();
        } else {
            this.value = dateUtil.convertDateStr(D, this.conn);
            this.unnullify();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        float f = 0.0f;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                Float F = Float.valueOf(this.valueTrimmed);
                f = F.floatValue();
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return f;
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = String.valueOf(f);
        this.unnullify();
    }

    @Override
    public void fromFloat(Float F) throws SQLException {
        if (F == null) {
            this.nullify();
        } else {
            this.value = F.toString();
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        long l = 0L;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                l = Long.parseLong(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return l;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = String.valueOf(l);
        this.unnullify();
    }

    @Override
    public void fromLong(Long L) throws SQLException {
        if (L == null) {
            this.nullify();
        } else {
            this.value = L.toString();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        short s = 0;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                s = Short.parseShort(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return s;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = String.valueOf(s);
        this.unnullify();
    }

    @Override
    public void fromShort(Short S) throws SQLException {
        if (S == null) {
            this.nullify();
        } else {
            this.value = S.toString();
            this.unnullify();
        }
    }

    @Override
    public Time toTime() throws SQLException {
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                return dateUtil.convertStringToTime(this.valueTrimmed, this.conn);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return null;
    }

    @Override
    public void fromTime(Time T) throws SQLException {
        if (T == null) {
            this.nullify();
        } else {
            long nmillis = T.getTime();
            this.value = dateUtil.convertDateTimeStr(T, this.conn, nmillis);
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        double d = 0.0;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                Double D = Double.valueOf(this.valueTrimmed);
                d = D;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return d;
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = String.valueOf(d);
        this.unnullify();
    }

    @Override
    public void fromDouble(Double D) throws SQLException {
        if (D == null) {
            this.nullify();
        } else {
            this.value = D.toString();
            this.unnullify();
        }
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                return dateUtil.convertStringToTimestamp(this.valueTrimmed, this.conn);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return null;
    }

    @Override
    public void fromTimestamp(Timestamp T) throws SQLException {
        if (T == null) {
            this.nullify();
        } else {
            long nmillis = T.getTime();
            this.value = dateUtil.convertDateTimeStr(T, this.conn, nmillis);
            this.unnullify();
        }
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.writeTrace(99, "IfxChar: toAsciiStream()");
        this.writeTrace(3, "IfxChar: toAsciiStream(): value = " + this.value);
        byte[] byteArray = this.value.getBytes();
        return new ByteArrayInputStream(byteArray);
    }

    @Override
    public void fromAsciiStream(InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length must be less than Integer.MAX_VALUE for this data type");
        }
        this.fromAsciiStream(x, (int)length);
    }

    @Override
    public void fromAsciiStream(InputStream x, int length) throws SQLException {
        this.writeTrace(3, "IfxChar: fromAsciiStream()");
        if (x != null) {
            if (length == 0) {
                this.value = "";
            } else {
                try {
                    if (length < 0) {
                        length = x.available();
                    }
                    this.writeTrace(3, "IfxChar: fromAsciiStream(): length = " + length);
                    byte[] b = new byte[length];
                    int offset = 0;
                    do {
                        int readLen = x.read(b, offset, length);
                        this.writeTrace(3, "IfxChar: fromAsciiStream(): readLen = " + readLen);
                        this.writeTrace(3, "IfxChar: fromAsciiStream(): length = " + (length -= readLen));
                        this.writeTrace(3, "IfxChar: fromAsciiStream(): offset = " + (offset += readLen));
                    } while (length > 0);
                    this.value = new String(b);
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
                }
                this.writeTrace(3, "IfxChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public void fromInputStream(InputStream x, long length) throws SQLException {
        this.fromAsciiStream(x, length);
    }

    @Override
    public void fromInputStream(InputStream x, int length) throws SQLException {
        this.fromAsciiStream(x, length);
    }

    @Override
    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromCharacterStream(Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length must be less than Integer.MAX_VALUE for this data type");
        }
        this.fromCharacterStream(reader, (int)length);
    }

    @Override
    public void fromCharacterStream(Reader x, int length) throws SQLException {
        if (length < 0) {
            throw IfxErrMsg.getSQLException(-79716, "Cannot read from Reader into a CHAR field w/o a length specified", this.conn);
        }
        this.writeTrace(3, "IfxChar: fromCharacterStream()");
        if (x != null) {
            this.writeTrace(3, "IfxChar: fromCharacterStream(): length = " + length);
            if (length == 0) {
                this.value = "";
            } else {
                char[] b = new char[length];
                int offset = 0;
                try {
                    do {
                        int readLen = x.read(b, offset, length);
                        this.writeTrace(3, "IfxChar: fromCharacterStream(): readLen = " + readLen);
                        this.writeTrace(3, "IfxChar: fromCharacterStream(): length = " + (length -= readLen));
                        this.writeTrace(3, "IfxChar: fromCharacterStream(): offset = " + (offset += readLen));
                    } while (length > 0);
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
                }
                this.value = new String(b);
                this.writeTrace(3, "IfxChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        this.writeTrace(3, "IfxChar: toCharacterStream()");
        if (this.isNull()) {
            return null;
        }
        this.writeTrace(3, "IfxChar: toCharacterStream(): value = " + this.value);
        return new StringReader(this.value);
    }

    private void trimIfxChar(String s) {
        int i;
        if (s == null) {
            this.value = s;
            this.valueTrimmed = s;
            this.nullify();
            return;
        }
        this.value = s;
        int length = s.length();
        if (this.value != null && this.value.length() > char_MaxLength) {
            this.value = this.value.substring(0, char_MaxLength);
        }
        for (i = length - 1; i >= 0 && s.charAt(i) == ' '; --i) {
        }
        this.valueTrimmed = i != length - 1 ? s.substring(0, ++i) : s;
        if (this.conn != null && this.conn.getTrimTrailingSpaces()) {
            this.trailing_trimmed = this.valueTrimmed;
        }
        length = this.valueTrimmed.length();
        for (i = 0; i < length && s.charAt(i) == ' '; ++i) {
        }
        if (i != 0) {
            this.valueTrimmed = this.valueTrimmed.substring(i, length);
        }
        this.unnullify();
    }
}

