/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Synonym;

public class CreateSynonymOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String value;
    private String synonym;

    private CreateSynonymOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.entity, (String)"entity cannot be empty");
        Validator.notEmpty((String)builder.value, (String)"value cannot be empty");
        Validator.notNull((Object)builder.synonym, (String)"synonym cannot be null");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
        this.synonym = builder.synonym;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public String synonym() {
        return this.synonym;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;
        private String synonym;

        private Builder(CreateSynonymOptions createSynonymOptions) {
            this.workspaceId = createSynonymOptions.workspaceId;
            this.entity = createSynonymOptions.entity;
            this.value = createSynonymOptions.value;
            this.synonym = createSynonymOptions.synonym;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value, String synonym) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
            this.synonym = synonym;
        }

        public CreateSynonymOptions build() {
            return new CreateSynonymOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder synonym(String synonym) {
            this.synonym = synonym;
            return this;
        }

        public Builder synonym(Synonym synonym) {
            this.synonym = synonym.synonym();
            return this;
        }
    }
}

