/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CreateValue
extends GenericModel {
    private String value;
    private Map metadata;
    @SerializedName(value="type")
    private String valueType;
    private List<String> synonyms;
    private List<String> patterns;
    private Date created;
    private Date updated;

    private CreateValue(Builder builder) {
        Validator.notNull((Object)builder.value, (String)"value cannot be null");
        this.value = builder.value;
        this.metadata = builder.metadata;
        this.valueType = builder.valueType;
        this.synonyms = builder.synonyms;
        this.patterns = builder.patterns;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String value() {
        return this.value;
    }

    public Map metadata() {
        return this.metadata;
    }

    public String valueType() {
        return this.valueType;
    }

    public List<String> synonyms() {
        return this.synonyms;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public Date created() {
        return this.created;
    }

    public Date updated() {
        return this.updated;
    }

    public static class Builder {
        private String value;
        private Map metadata;
        private String valueType;
        private List<String> synonyms;
        private List<String> patterns;
        private Date created;
        private Date updated;

        private Builder(CreateValue createValue) {
            this.value = createValue.value;
            this.metadata = createValue.metadata;
            this.valueType = createValue.valueType;
            this.synonyms = createValue.synonyms;
            this.patterns = createValue.patterns;
            this.created = createValue.created;
            this.updated = createValue.updated;
        }

        public Builder() {
        }

        public Builder(String value) {
            this.value = value;
        }

        public CreateValue build() {
            return new CreateValue(this);
        }

        public Builder addSynonym(String synonym) {
            Validator.notNull((Object)synonym, (String)"synonym cannot be null");
            if (this.synonyms == null) {
                this.synonyms = new ArrayList<String>();
            }
            this.synonyms.add(synonym);
            return this;
        }

        public Builder addPattern(String pattern) {
            Validator.notNull((Object)pattern, (String)"pattern cannot be null");
            if (this.patterns == null) {
                this.patterns = new ArrayList<String>();
            }
            this.patterns.add(pattern);
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder metadata(Map metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder synonyms(List<String> synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public Builder patterns(List<String> patterns) {
            this.patterns = patterns;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }
    }

    public static interface ValueType {
        public static final String SYNONYMS = "synonyms";
        public static final String PATTERNS = "patterns";
    }
}

