/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Context;
import com.ibm.watson.assistant.v1.model.MessageInput;
import com.ibm.watson.assistant.v1.model.MessageRequest;
import com.ibm.watson.assistant.v1.model.OutputData;
import com.ibm.watson.assistant.v1.model.RuntimeEntity;
import com.ibm.watson.assistant.v1.model.RuntimeIntent;
import java.util.ArrayList;
import java.util.List;

public class MessageOptions
extends GenericModel {
    private String workspaceId;
    private MessageInput input;
    private List<RuntimeIntent> intents;
    private List<RuntimeEntity> entities;
    private Boolean alternateIntents;
    private Context context;
    private OutputData output;
    private Boolean nodesVisitedDetails;

    private MessageOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.input = builder.input;
        this.intents = builder.intents;
        this.entities = builder.entities;
        this.alternateIntents = builder.alternateIntents;
        this.context = builder.context;
        this.output = builder.output;
        this.nodesVisitedDetails = builder.nodesVisitedDetails;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public MessageInput input() {
        return this.input;
    }

    public List<RuntimeIntent> intents() {
        return this.intents;
    }

    public List<RuntimeEntity> entities() {
        return this.entities;
    }

    public Boolean alternateIntents() {
        return this.alternateIntents;
    }

    public Context context() {
        return this.context;
    }

    public OutputData output() {
        return this.output;
    }

    public Boolean nodesVisitedDetails() {
        return this.nodesVisitedDetails;
    }

    public static class Builder {
        private String workspaceId;
        private MessageInput input;
        private List<RuntimeIntent> intents;
        private List<RuntimeEntity> entities;
        private Boolean alternateIntents;
        private Context context;
        private OutputData output;
        private Boolean nodesVisitedDetails;

        private Builder(MessageOptions messageOptions) {
            this.workspaceId = messageOptions.workspaceId;
            this.input = messageOptions.input;
            this.intents = messageOptions.intents;
            this.entities = messageOptions.entities;
            this.alternateIntents = messageOptions.alternateIntents;
            this.context = messageOptions.context;
            this.output = messageOptions.output;
            this.nodesVisitedDetails = messageOptions.nodesVisitedDetails;
        }

        public Builder() {
        }

        public Builder(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public MessageOptions build() {
            return new MessageOptions(this);
        }

        public Builder addIntent(RuntimeIntent intent) {
            Validator.notNull((Object)((Object)intent), (String)"intent cannot be null");
            if (this.intents == null) {
                this.intents = new ArrayList<RuntimeIntent>();
            }
            this.intents.add(intent);
            return this;
        }

        public Builder addEntity(RuntimeEntity entity) {
            Validator.notNull((Object)((Object)entity), (String)"entity cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<RuntimeEntity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder input(MessageInput input) {
            this.input = input;
            return this;
        }

        public Builder intents(List<RuntimeIntent> intents) {
            this.intents = intents;
            return this;
        }

        public Builder entities(List<RuntimeEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder alternateIntents(Boolean alternateIntents) {
            this.alternateIntents = alternateIntents;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder output(OutputData output) {
            this.output = output;
            return this;
        }

        public Builder nodesVisitedDetails(Boolean nodesVisitedDetails) {
            this.nodesVisitedDetails = nodesVisitedDetails;
            return this;
        }

        public Builder messageRequest(MessageRequest messageRequest) {
            this.input = messageRequest.getInput();
            this.intents = messageRequest.getIntents();
            this.entities = messageRequest.getEntities();
            this.alternateIntents = messageRequest.isAlternateIntents();
            this.context = messageRequest.getContext();
            this.output = messageRequest.getOutput();
            return this;
        }
    }
}

