/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Counterexample;
import com.ibm.watson.assistant.v1.model.CreateEntity;
import com.ibm.watson.assistant.v1.model.CreateIntent;
import com.ibm.watson.assistant.v1.model.DialogNode;
import com.ibm.watson.assistant.v1.model.WorkspaceSystemSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateWorkspaceOptions
extends GenericModel {
    private String workspaceId;
    private String name;
    private String description;
    private String language;
    private Map<String, Object> metadata;
    private Boolean learningOptOut;
    private WorkspaceSystemSettings systemSettings;
    private List<CreateIntent> intents;
    private List<CreateEntity> entities;
    private List<DialogNode> dialogNodes;
    private List<Counterexample> counterexamples;
    private Boolean append;

    private UpdateWorkspaceOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.name = builder.name;
        this.description = builder.description;
        this.language = builder.language;
        this.metadata = builder.metadata;
        this.learningOptOut = builder.learningOptOut;
        this.systemSettings = builder.systemSettings;
        this.intents = builder.intents;
        this.entities = builder.entities;
        this.dialogNodes = builder.dialogNodes;
        this.counterexamples = builder.counterexamples;
        this.append = builder.append;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String language() {
        return this.language;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public Boolean learningOptOut() {
        return this.learningOptOut;
    }

    public WorkspaceSystemSettings systemSettings() {
        return this.systemSettings;
    }

    public List<CreateIntent> intents() {
        return this.intents;
    }

    public List<CreateEntity> entities() {
        return this.entities;
    }

    public List<DialogNode> dialogNodes() {
        return this.dialogNodes;
    }

    public List<Counterexample> counterexamples() {
        return this.counterexamples;
    }

    public Boolean append() {
        return this.append;
    }

    public static class Builder {
        private String workspaceId;
        private String name;
        private String description;
        private String language;
        private Map<String, Object> metadata;
        private Boolean learningOptOut;
        private WorkspaceSystemSettings systemSettings;
        private List<CreateIntent> intents;
        private List<CreateEntity> entities;
        private List<DialogNode> dialogNodes;
        private List<Counterexample> counterexamples;
        private Boolean append;

        private Builder(UpdateWorkspaceOptions updateWorkspaceOptions) {
            this.workspaceId = updateWorkspaceOptions.workspaceId;
            this.name = updateWorkspaceOptions.name;
            this.description = updateWorkspaceOptions.description;
            this.language = updateWorkspaceOptions.language;
            this.metadata = updateWorkspaceOptions.metadata;
            this.learningOptOut = updateWorkspaceOptions.learningOptOut;
            this.systemSettings = updateWorkspaceOptions.systemSettings;
            this.intents = updateWorkspaceOptions.intents;
            this.entities = updateWorkspaceOptions.entities;
            this.dialogNodes = updateWorkspaceOptions.dialogNodes;
            this.counterexamples = updateWorkspaceOptions.counterexamples;
            this.append = updateWorkspaceOptions.append;
        }

        public Builder() {
        }

        public Builder(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public UpdateWorkspaceOptions build() {
            return new UpdateWorkspaceOptions(this);
        }

        public Builder addIntent(CreateIntent intent) {
            Validator.notNull((Object)((Object)intent), (String)"intent cannot be null");
            if (this.intents == null) {
                this.intents = new ArrayList<CreateIntent>();
            }
            this.intents.add(intent);
            return this;
        }

        public Builder addEntity(CreateEntity entity) {
            Validator.notNull((Object)((Object)entity), (String)"entity cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<CreateEntity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder addDialogNode(DialogNode dialogNode) {
            Validator.notNull((Object)((Object)dialogNode), (String)"dialogNode cannot be null");
            if (this.dialogNodes == null) {
                this.dialogNodes = new ArrayList<DialogNode>();
            }
            this.dialogNodes.add(dialogNode);
            return this;
        }

        public Builder addCounterexample(Counterexample counterexample) {
            Validator.notNull((Object)((Object)counterexample), (String)"counterexample cannot be null");
            if (this.counterexamples == null) {
                this.counterexamples = new ArrayList<Counterexample>();
            }
            this.counterexamples.add(counterexample);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder learningOptOut(Boolean learningOptOut) {
            this.learningOptOut = learningOptOut;
            return this;
        }

        public Builder systemSettings(WorkspaceSystemSettings systemSettings) {
            this.systemSettings = systemSettings;
            return this;
        }

        public Builder intents(List<CreateIntent> intents) {
            this.intents = intents;
            return this;
        }

        public Builder entities(List<CreateEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder dialogNodes(List<DialogNode> dialogNodes) {
            this.dialogNodes = dialogNodes;
            return this;
        }

        public Builder counterexamples(List<Counterexample> counterexamples) {
            this.counterexamples = counterexamples;
            return this;
        }

        public Builder append(Boolean append) {
            this.append = append;
            return this;
        }
    }
}

