/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.DialogNodeOutputOptionsElement;
import com.ibm.watson.assistant.v2.model.DialogSuggestion;
import com.ibm.watson.assistant.v2.model.SearchResult;
import java.util.ArrayList;
import java.util.List;

public class DialogRuntimeResponseGeneric
extends GenericModel {
    @SerializedName(value="response_type")
    private String responseType;
    private String text;
    private Long time;
    private Boolean typing;
    private String source;
    private String title;
    private String description;
    private String preference;
    private List<DialogNodeOutputOptionsElement> options;
    @SerializedName(value="message_to_human_agent")
    private String messageToHumanAgent;
    private String topic;
    private List<DialogSuggestion> suggestions;
    private String header;
    private List<SearchResult> results;

    private DialogRuntimeResponseGeneric(Builder builder) {
        Validator.notNull((Object)builder.responseType, (String)"responseType cannot be null");
        this.responseType = builder.responseType;
        this.text = builder.text;
        this.time = builder.time;
        this.typing = builder.typing;
        this.source = builder.source;
        this.title = builder.title;
        this.description = builder.description;
        this.preference = builder.preference;
        this.options = builder.options;
        this.messageToHumanAgent = builder.messageToHumanAgent;
        this.topic = builder.topic;
        this.suggestions = builder.suggestions;
        this.header = builder.header;
        this.results = builder.results;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getText() {
        return this.text;
    }

    public Long getTime() {
        return this.time;
    }

    public Boolean isTyping() {
        return this.typing;
    }

    public String getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPreference() {
        return this.preference;
    }

    public List<DialogNodeOutputOptionsElement> getOptions() {
        return this.options;
    }

    public String getMessageToHumanAgent() {
        return this.messageToHumanAgent;
    }

    public String getTopic() {
        return this.topic;
    }

    public List<DialogSuggestion> getSuggestions() {
        return this.suggestions;
    }

    public String getHeader() {
        return this.header;
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    public static class Builder {
        private String responseType;
        private String text;
        private Long time;
        private Boolean typing;
        private String source;
        private String title;
        private String description;
        private String preference;
        private List<DialogNodeOutputOptionsElement> options;
        private String messageToHumanAgent;
        private String topic;
        private List<DialogSuggestion> suggestions;
        private String header;
        private List<SearchResult> results;

        private Builder(DialogRuntimeResponseGeneric dialogRuntimeResponseGeneric) {
            this.responseType = dialogRuntimeResponseGeneric.responseType;
            this.text = dialogRuntimeResponseGeneric.text;
            this.time = dialogRuntimeResponseGeneric.time;
            this.typing = dialogRuntimeResponseGeneric.typing;
            this.source = dialogRuntimeResponseGeneric.source;
            this.title = dialogRuntimeResponseGeneric.title;
            this.description = dialogRuntimeResponseGeneric.description;
            this.preference = dialogRuntimeResponseGeneric.preference;
            this.options = dialogRuntimeResponseGeneric.options;
            this.messageToHumanAgent = dialogRuntimeResponseGeneric.messageToHumanAgent;
            this.topic = dialogRuntimeResponseGeneric.topic;
            this.suggestions = dialogRuntimeResponseGeneric.suggestions;
            this.header = dialogRuntimeResponseGeneric.header;
            this.results = dialogRuntimeResponseGeneric.results;
        }

        public Builder() {
        }

        public Builder(String responseType) {
            this.responseType = responseType;
        }

        public DialogRuntimeResponseGeneric build() {
            return new DialogRuntimeResponseGeneric(this);
        }

        public Builder addOptions(DialogNodeOutputOptionsElement options) {
            Validator.notNull((Object)((Object)options), (String)"options cannot be null");
            if (this.options == null) {
                this.options = new ArrayList<DialogNodeOutputOptionsElement>();
            }
            this.options.add(options);
            return this;
        }

        public Builder addSuggestions(DialogSuggestion suggestions) {
            Validator.notNull((Object)((Object)suggestions), (String)"suggestions cannot be null");
            if (this.suggestions == null) {
                this.suggestions = new ArrayList<DialogSuggestion>();
            }
            this.suggestions.add(suggestions);
            return this;
        }

        public Builder addResults(SearchResult results) {
            Validator.notNull((Object)((Object)results), (String)"results cannot be null");
            if (this.results == null) {
                this.results = new ArrayList<SearchResult>();
            }
            this.results.add(results);
            return this;
        }

        public Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Builder typing(Boolean typing) {
            this.typing = typing;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder preference(String preference) {
            this.preference = preference;
            return this;
        }

        public Builder options(List<DialogNodeOutputOptionsElement> options) {
            this.options = options;
            return this;
        }

        public Builder messageToHumanAgent(String messageToHumanAgent) {
            this.messageToHumanAgent = messageToHumanAgent;
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder suggestions(List<DialogSuggestion> suggestions) {
            this.suggestions = suggestions;
            return this;
        }

        public Builder header(String header) {
            this.header = header;
            return this;
        }

        public Builder results(List<SearchResult> results) {
            this.results = results;
            return this;
        }
    }

    public static interface Preference {
        public static final String DROPDOWN = "dropdown";
        public static final String BUTTON = "button";
    }

    public static interface ResponseType {
        public static final String TEXT = "text";
        public static final String PAUSE = "pause";
        public static final String IMAGE = "image";
        public static final String OPTION = "option";
        public static final String CONNECT_TO_AGENT = "connect_to_agent";
        public static final String SUGGESTION = "suggestion";
        public static final String SEARCH = "search";
    }
}

