/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tone_analyzer.v3;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.tone_analyzer.v3.model.ToneAnalysis;
import com.ibm.watson.developer_cloud.tone_analyzer.v3.model.ToneChatOptions;
import com.ibm.watson.developer_cloud.tone_analyzer.v3.model.ToneOptions;
import com.ibm.watson.developer_cloud.tone_analyzer.v3.model.UtteranceAnalyses;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import okhttp3.HttpUrl;

public class ToneAnalyzer
extends WatsonService {
    private static final String SERVICE_NAME = "tone_analyzer";
    private static final String URL = "https://gateway.watsonplatform.net/tone-analyzer/api";
    private String versionDate;

    public ToneAnalyzer(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public ToneAnalyzer(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public ToneAnalyzer(String versionDate, IamOptions iamOptions) {
        this(versionDate);
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<ToneAnalysis> tone(ToneOptions toneOptions) {
        Validator.notNull((Object)((Object)toneOptions), (String)"toneOptions cannot be null");
        String[] pathSegments = new String[]{"v3/tone"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        builder.header(new Object[]{"Content-Type", toneOptions.contentType()});
        if (toneOptions.contentLanguage() != null) {
            builder.header(new Object[]{"Content-Language", toneOptions.contentLanguage()});
        }
        if (toneOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", toneOptions.acceptLanguage()});
        }
        if (toneOptions.sentences() != null) {
            builder.query(new Object[]{"sentences", String.valueOf(toneOptions.sentences())});
        }
        if (toneOptions.tones() != null) {
            builder.query(new Object[]{"tones", RequestUtils.join(toneOptions.tones(), (String)",")});
        }
        builder.bodyContent(toneOptions.contentType(), (Object)toneOptions.toneInput(), null, toneOptions.body());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ToneAnalysis.class));
    }

    public ServiceCall<UtteranceAnalyses> toneChat(ToneChatOptions toneChatOptions) {
        Validator.notNull((Object)((Object)toneChatOptions), (String)"toneChatOptions cannot be null");
        String[] pathSegments = new String[]{"v3/tone_chat"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        if (toneChatOptions.contentLanguage() != null) {
            builder.header(new Object[]{"Content-Language", toneChatOptions.contentLanguage()});
        }
        if (toneChatOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", toneChatOptions.acceptLanguage()});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("utterances", GsonSingleton.getGson().toJsonTree(toneChatOptions.utterances()));
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(UtteranceAnalyses.class));
    }
}

