/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.language_translator.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateModelOptions
extends GenericModel {
    private String baseModelId;
    private InputStream forcedGlossary;
    private InputStream parallelCorpus;
    private String name;

    private CreateModelOptions(Builder builder) {
        Validator.notNull((Object)builder.baseModelId, (String)"baseModelId cannot be null");
        this.baseModelId = builder.baseModelId;
        this.forcedGlossary = builder.forcedGlossary;
        this.parallelCorpus = builder.parallelCorpus;
        this.name = builder.name;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String baseModelId() {
        return this.baseModelId;
    }

    public InputStream forcedGlossary() {
        return this.forcedGlossary;
    }

    public InputStream parallelCorpus() {
        return this.parallelCorpus;
    }

    public String name() {
        return this.name;
    }

    public static class Builder {
        private String baseModelId;
        private InputStream forcedGlossary;
        private InputStream parallelCorpus;
        private String name;

        private Builder(CreateModelOptions createModelOptions) {
            this.baseModelId = createModelOptions.baseModelId;
            this.forcedGlossary = createModelOptions.forcedGlossary;
            this.parallelCorpus = createModelOptions.parallelCorpus;
            this.name = createModelOptions.name;
        }

        public Builder() {
        }

        public Builder(String baseModelId) {
            this.baseModelId = baseModelId;
        }

        public CreateModelOptions build() {
            return new CreateModelOptions(this);
        }

        public Builder baseModelId(String baseModelId) {
            this.baseModelId = baseModelId;
            return this;
        }

        public Builder forcedGlossary(InputStream forcedGlossary) {
            this.forcedGlossary = forcedGlossary;
            return this;
        }

        public Builder parallelCorpus(InputStream parallelCorpus) {
            this.parallelCorpus = parallelCorpus;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder forcedGlossary(File forcedGlossary) throws FileNotFoundException {
            this.forcedGlossary = new FileInputStream(forcedGlossary);
            return this;
        }

        public Builder parallelCorpus(File parallelCorpus) throws FileNotFoundException {
            this.parallelCorpus = new FileInputStream(parallelCorpus);
            return this;
        }
    }
}

