/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.language_translator.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class GetTranslatedDocumentOptions
extends GenericModel {
    private String documentId;
    private String accept;

    private GetTranslatedDocumentOptions(Builder builder) {
        Validator.notEmpty((String)builder.documentId, (String)"documentId cannot be empty");
        this.documentId = builder.documentId;
        this.accept = builder.accept;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String documentId() {
        return this.documentId;
    }

    public String accept() {
        return this.accept;
    }

    public static class Builder {
        private String documentId;
        private String accept;

        private Builder(GetTranslatedDocumentOptions getTranslatedDocumentOptions) {
            this.documentId = getTranslatedDocumentOptions.documentId;
            this.accept = getTranslatedDocumentOptions.accept;
        }

        public Builder() {
        }

        public Builder(String documentId) {
            this.documentId = documentId;
        }

        public GetTranslatedDocumentOptions build() {
            return new GetTranslatedDocumentOptions(this);
        }

        public Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public Builder accept(String accept) {
            this.accept = accept;
            return this;
        }
    }

    public static interface Accept {
        public static final String APPLICATION_POWERPOINT = "application/powerpoint";
        public static final String APPLICATION_MSPOWERPOINT = "application/mspowerpoint";
        public static final String APPLICATION_X_RTF = "application/x-rtf";
        public static final String APPLICATION_JSON = "application/json";
        public static final String APPLICATION_XML = "application/xml";
        public static final String APPLICATION_VND_MS_EXCEL = "application/vnd.ms-excel";
        public static final String APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        public static final String APPLICATION_VND_MS_POWERPOINT = "application/vnd.ms-powerpoint";
        public static final String APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        public static final String APPLICATION_MSWORD = "application/msword";
        public static final String APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        public static final String APPLICATION_VND_OASIS_OPENDOCUMENT_SPREADSHEET = "application/vnd.oasis.opendocument.spreadsheet";
        public static final String APPLICATION_VND_OASIS_OPENDOCUMENT_PRESENTATION = "application/vnd.oasis.opendocument.presentation";
        public static final String APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT = "application/vnd.oasis.opendocument.text";
        public static final String APPLICATION_PDF = "application/pdf";
        public static final String APPLICATION_RTF = "application/rtf";
        public static final String TEXT_HTML = "text/html";
        public static final String TEXT_JSON = "text/json";
        public static final String TEXT_PLAIN = "text/plain";
        public static final String TEXT_RICHTEXT = "text/richtext";
        public static final String TEXT_RTF = "text/rtf";
        public static final String TEXT_XML = "text/xml";
    }
}

