/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v3;

import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.AuthenticatorConfig;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.visual_recognition.v3.model.ClassifiedImages;
import com.ibm.watson.visual_recognition.v3.model.Classifier;
import com.ibm.watson.visual_recognition.v3.model.Classifiers;
import com.ibm.watson.visual_recognition.v3.model.ClassifyOptions;
import com.ibm.watson.visual_recognition.v3.model.CreateClassifierOptions;
import com.ibm.watson.visual_recognition.v3.model.DeleteClassifierOptions;
import com.ibm.watson.visual_recognition.v3.model.DeleteUserDataOptions;
import com.ibm.watson.visual_recognition.v3.model.DetectFacesOptions;
import com.ibm.watson.visual_recognition.v3.model.DetectedFaces;
import com.ibm.watson.visual_recognition.v3.model.GetClassifierOptions;
import com.ibm.watson.visual_recognition.v3.model.GetCoreMlModelOptions;
import com.ibm.watson.visual_recognition.v3.model.ListClassifiersOptions;
import com.ibm.watson.visual_recognition.v3.model.UpdateClassifierOptions;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class VisualRecognition
extends BaseService {
    private static final String SERVICE_NAME = "visual_recognition";
    private static final String URL = "https://gateway.watsonplatform.net/visual-recognition/api";
    private String versionDate;

    @Deprecated
    public VisualRecognition(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public VisualRecognition(String versionDate, AuthenticatorConfig authenticatorConfig) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        this.setAuthenticator(authenticatorConfig);
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public ServiceCall<ClassifiedImages> classify(ClassifyOptions classifyOptions) {
        Validator.notNull((Object)((Object)classifyOptions), (String)"classifyOptions cannot be null");
        Validator.isTrue((classifyOptions.imagesFile() != null || classifyOptions.url() != null || classifyOptions.threshold() != null || classifyOptions.owners() != null || classifyOptions.classifierIds() != null ? 1 : 0) != 0, (String)"At least one of imagesFile, url, threshold, owners, or classifierIds must be supplied.");
        String[] pathSegments = new String[]{"v3/classify"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"classify");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (classifyOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", classifyOptions.acceptLanguage()});
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (classifyOptions.imagesFile() != null) {
            RequestBody imagesFileBody = RequestUtils.inputStreamBody((InputStream)classifyOptions.imagesFile(), (String)classifyOptions.imagesFileContentType());
            multipartBuilder.addFormDataPart("images_file", classifyOptions.imagesFilename(), imagesFileBody);
        }
        if (classifyOptions.url() != null) {
            multipartBuilder.addFormDataPart("url", classifyOptions.url());
        }
        if (classifyOptions.threshold() != null) {
            multipartBuilder.addFormDataPart("threshold", String.valueOf(classifyOptions.threshold()));
        }
        if (classifyOptions.owners() != null) {
            multipartBuilder.addFormDataPart("owners", RequestUtils.join(classifyOptions.owners(), (String)","));
        }
        if (classifyOptions.classifierIds() != null) {
            multipartBuilder.addFormDataPart("classifier_ids", RequestUtils.join(classifyOptions.classifierIds(), (String)","));
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ClassifiedImages>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassifiedImages> classify() {
        return this.classify(null);
    }

    public ServiceCall<DetectedFaces> detectFaces(DetectFacesOptions detectFacesOptions) {
        Validator.notNull((Object)((Object)detectFacesOptions), (String)"detectFacesOptions cannot be null");
        Validator.isTrue((detectFacesOptions.imagesFile() != null || detectFacesOptions.url() != null ? 1 : 0) != 0, (String)"At least one of imagesFile or url must be supplied.");
        String[] pathSegments = new String[]{"v3/detect_faces"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"detectFaces");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (detectFacesOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", detectFacesOptions.acceptLanguage()});
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (detectFacesOptions.imagesFile() != null) {
            RequestBody imagesFileBody = RequestUtils.inputStreamBody((InputStream)detectFacesOptions.imagesFile(), (String)detectFacesOptions.imagesFileContentType());
            multipartBuilder.addFormDataPart("images_file", detectFacesOptions.imagesFilename(), imagesFileBody);
        }
        if (detectFacesOptions.url() != null) {
            multipartBuilder.addFormDataPart("url", detectFacesOptions.url());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DetectedFaces>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DetectedFaces> detectFaces() {
        return this.detectFaces(null);
    }

    /*
     * WARNING - void declaration
     */
    public ServiceCall<Classifier> createClassifier(CreateClassifierOptions createClassifierOptions) {
        Validator.notNull((Object)((Object)createClassifierOptions), (String)"createClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"createClassifier");
        for (Map.Entry entry : sdkHeaders.entrySet()) {
            builder.header(new Object[]{entry.getKey(), entry.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("name", createClassifierOptions.name());
        for (Map.Entry<String, InputStream> entry : createClassifierOptions.positiveExamples().entrySet()) {
            String partName = String.format("%s_positive_examples", entry.getKey());
            RequestBody part = RequestUtils.inputStreamBody((InputStream)entry.getValue(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart(partName, entry.getKey() + ".zip", part);
        }
        if (createClassifierOptions.negativeExamples() != null) {
            void var7_14;
            RequestBody requestBody = RequestUtils.inputStreamBody((InputStream)createClassifierOptions.negativeExamples(), (String)"application/octet-stream");
            String string = createClassifierOptions.negativeExamplesFilename();
            if (!string.contains(".")) {
                String string2 = string + ".zip";
            }
            multipartBuilder.addFormDataPart("negative_examples", (String)var7_14, requestBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Classifiers> listClassifiers(ListClassifiersOptions listClassifiersOptions) {
        String[] pathSegments = new String[]{"v3/classifiers"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"listClassifiers");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listClassifiersOptions != null && listClassifiersOptions.verbose() != null) {
            builder.query(new Object[]{"verbose", String.valueOf(listClassifiersOptions.verbose())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifiers>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Classifiers> listClassifiers() {
        return this.listClassifiers(null);
    }

    public ServiceCall<Classifier> getClassifier(GetClassifierOptions getClassifierOptions) {
        Validator.notNull((Object)((Object)getClassifierOptions), (String)"getClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers"};
        String[] pathParameters = new String[]{getClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"getClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Classifier> updateClassifier(UpdateClassifierOptions updateClassifierOptions) {
        Validator.notNull((Object)((Object)updateClassifierOptions), (String)"updateClassifierOptions cannot be null");
        Validator.isTrue((updateClassifierOptions.positiveExamples() != null || updateClassifierOptions.negativeExamples() != null ? 1 : 0) != 0, (String)"At least one of positiveExamples or negativeExamples must be supplied.");
        String[] pathSegments = new String[]{"v3/classifiers"};
        String[] pathParameters = new String[]{updateClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"updateClassifier");
        for (Map.Entry entry : sdkHeaders.entrySet()) {
            builder.header(new Object[]{entry.getKey(), entry.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (updateClassifierOptions.positiveExamples() != null) {
            for (Map.Entry<String, InputStream> entry : updateClassifierOptions.positiveExamples().entrySet()) {
                String partName = String.format("%s_positive_examples", entry.getKey());
                RequestBody part = RequestUtils.inputStreamBody((InputStream)entry.getValue(), (String)"application/octet-stream");
                multipartBuilder.addFormDataPart(partName, entry.getKey(), part);
            }
        }
        if (updateClassifierOptions.negativeExamples() != null) {
            RequestBody requestBody = RequestUtils.inputStreamBody((InputStream)updateClassifierOptions.negativeExamples(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart("negative_examples", updateClassifierOptions.negativeExamplesFilename(), requestBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteClassifier(DeleteClassifierOptions deleteClassifierOptions) {
        Validator.notNull((Object)((Object)deleteClassifierOptions), (String)"deleteClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers"};
        String[] pathParameters = new String[]{deleteClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"deleteClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getCoreMlModel(GetCoreMlModelOptions getCoreMlModelOptions) {
        Validator.notNull((Object)((Object)getCoreMlModelOptions), (String)"getCoreMlModelOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers", "core_ml_model"};
        String[] pathParameters = new String[]{getCoreMlModelOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"getCoreMlModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/octet-stream"});
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v3/user_data"};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"customer_id", deleteUserDataOptions.customerId()});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

