/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class DetectFacesOptions
extends GenericModel {
    private InputStream imagesFile;
    private String imagesFilename;
    private String imagesFileContentType;
    private String url;
    private String acceptLanguage;

    private DetectFacesOptions(Builder builder) {
        Validator.isTrue((builder.imagesFile == null || builder.imagesFilename != null ? 1 : 0) != 0, (String)"imagesFilename cannot be null if imagesFile is not null.");
        this.imagesFile = builder.imagesFile;
        this.imagesFilename = builder.imagesFilename;
        this.imagesFileContentType = builder.imagesFileContentType;
        this.url = builder.url;
        this.acceptLanguage = builder.acceptLanguage;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream imagesFile() {
        return this.imagesFile;
    }

    public String imagesFilename() {
        return this.imagesFilename;
    }

    public String imagesFileContentType() {
        return this.imagesFileContentType;
    }

    public String url() {
        return this.url;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public static class Builder {
        private InputStream imagesFile;
        private String imagesFilename;
        private String imagesFileContentType;
        private String url;
        private String acceptLanguage;

        private Builder(DetectFacesOptions detectFacesOptions) {
            this.imagesFile = detectFacesOptions.imagesFile;
            this.imagesFilename = detectFacesOptions.imagesFilename;
            this.imagesFileContentType = detectFacesOptions.imagesFileContentType;
            this.url = detectFacesOptions.url;
            this.acceptLanguage = detectFacesOptions.acceptLanguage;
        }

        public Builder() {
        }

        public DetectFacesOptions build() {
            return new DetectFacesOptions(this);
        }

        public Builder imagesFile(InputStream imagesFile) {
            this.imagesFile = imagesFile;
            return this;
        }

        public Builder imagesFilename(String imagesFilename) {
            this.imagesFilename = imagesFilename;
            return this;
        }

        public Builder imagesFileContentType(String imagesFileContentType) {
            this.imagesFileContentType = imagesFileContentType;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder imagesFile(File imagesFile) throws FileNotFoundException {
            this.imagesFile = new FileInputStream(imagesFile);
            this.imagesFilename = imagesFile.getName();
            return this;
        }
    }

    public static interface AcceptLanguage {
        public static final String EN = "en";
        public static final String AR = "ar";
        public static final String DE = "de";
        public static final String ES = "es";
        public static final String FR = "fr";
        public static final String IT = "it";
        public static final String JA = "ja";
        public static final String KO = "ko";
        public static final String PT_BR = "pt-br";
        public static final String ZH_CN = "zh-cn";
        public static final String ZH_TW = "zh-tw";
    }
}

