/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.pseudo.internal.PseudoContextFactory;
import com.ibm.ws.kernel.service.location.internal.VariableRegistryHelper;
import com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.checkpoint.spi.CheckpointHook;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Hashtable;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.condition.Condition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Activator
implements BundleActivator {
    private static final TraceComponent tc = Tr.register(Activator.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
    protected BundleContext context = null;
    private PseudoContextFactory contextFactory;
    private ServiceRegistration<WsLocationAdmin> wsLocationAdminRegistration;
    private ServiceRegistration<VariableRegistry> variableRegistryRegistration;
    private ServiceRegistration<CheckpointHook> checkpointHookRegistration;
    static final long serialVersionUID = -8043059569099290449L;

    @FFDCIgnore(value={IllegalStateException.class})
    public void start(BundleContext context) throws Exception {
        this.context = context;
        FrameworkState.isValid();
        try {
            WsLocationAdminImpl locServiceImpl = WsLocationAdminImpl.createLocations(context.getBundle(0L).getBundleContext());
            this.wsLocationAdminRegistration = context.registerService(WsLocationAdmin.class, (Object)locServiceImpl, locServiceImpl.getServiceProps());
            VariableRegistryHelper variableRegistry = new VariableRegistryHelper();
            this.variableRegistryRegistration = context.registerService(VariableRegistry.class, (Object)variableRegistry, null);
            this.checkpointHookRegistration = context.registerService(CheckpointHook.class, (Object)locServiceImpl, FrameworkUtil.asDictionary(Collections.singletonMap("service.ranking", 100)));
            Hashtable<String, Object> javaConditionProps = new Hashtable<String, Object>();
            javaConditionProps.put("io.openliberty.java.version", JavaInfo.majorVersion());
            javaConditionProps.put("osgi.condition.id", "io.openliberty.java.version");
            context.registerService(Condition.class, (Object)Condition.INSTANCE, javaConditionProps);
            try {
                PseudoContextFactory factory = new PseudoContextFactory();
                NamingManager.setInitialContextFactoryBuilder(factory);
                this.contextFactory = factory;
            }
            catch (IllegalStateException ex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to install initialContextFactoryBuilder because it was already installed", (Object[])new Object[]{ex});
                }
            }
        }
        catch (Exception locServiceImpl) {
            FFDCFilter.processException((Throwable)locServiceImpl, (String)"com.ibm.ws.kernel.service.location.internal.Activator", (String)"93", (Object)this, (Object[])new Object[]{context});
            Tr.audit((TraceComponent)tc, (String)"frameworkShutdown", (Object[])new Object[0]);
            this.shutdownFramework();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void stop(BundleContext context) throws Exception {
        block8: {
            this.context = null;
            if (this.wsLocationAdminRegistration != null) {
                this.wsLocationAdminRegistration.unregister();
            }
            if (this.variableRegistryRegistration != null) {
                this.variableRegistryRegistration.unregister();
            }
            if (this.checkpointHookRegistration != null) {
                this.checkpointHookRegistration.unregister();
            }
            if (this.contextFactory != null) {
                try {
                    for (Field field : NamingManager.class.getDeclaredFields()) {
                        if (!InitialContextFactoryBuilder.class.equals(field.getType())) continue;
                        field.setAccessible(true);
                        if (field.get(null) == this.contextFactory) {
                            field.set(null, null);
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    void ex;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.location.internal.Activator", (String)"132", (Object)this, (Object[])new Object[]{context});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"Failed to uninstall initialContextFactoryBuilder", (Object[])new Object[]{ex});
                }
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    protected final void shutdownFramework() {
        try {
            Bundle bundle = this.context.getBundle("System Bundle");
            if (bundle != null) {
                bundle.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

