/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.internal.FeatureResolverImpl;
import com.ibm.ws.kernel.feature.internal.util.BiTransformer;
import com.ibm.ws.kernel.feature.internal.util.LazySupplierImpl;
import com.ibm.ws.kernel.feature.internal.util.RepoXML;
import com.ibm.ws.kernel.feature.internal.util.Transformer;
import com.ibm.ws.kernel.feature.internal.util.VerifyData;
import com.ibm.ws.kernel.feature.internal.util.VerifyEnv;
import com.ibm.ws.kernel.feature.internal.util.VerifyXML;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FeatureResolverBaseline {
    public static final String WAS_LIBERTY_TAIL = "_WL";
    private final FeatureResolverImpl resolver;
    private final FeatureResolver.Repository repository;
    private static final String WAS_LIBERTY_FEATURE_NAME = "apiDiscovery-1.0";
    private static final String SERVLET_VERSIONLESS_PREFIX = "servlet-";
    private static final String VERSIONLESS_PREFIX = "io.openliberty.versionless.";
    private static final String VERSIONLESS_MP_PREFIX = "io.openliberty.versionless.mp";
    private static final boolean INCLUDE_EE = true;
    private static final boolean INCLUDE_MP = true;
    private static Comparator<ProvisioningFeatureDefinition> COMPARE_SYMBOLIC;
    static final long serialVersionUID = 1250696013879235195L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void printPath(String tag, String path) {
        String absPath = path == null ? null : new File(path).getAbsolutePath();
        System.out.println(tag + ": [ " + absPath + " ]");
    }

    @Trivial
    protected static void trace(String message) {
        FeatureResolverImpl.trace(message);
    }

    @Trivial
    protected static void error(String message, Object ... parms) {
        FeatureResolverImpl.error(message, parms);
    }

    @Trivial
    protected static void info(String message, Object ... parms) {
        FeatureResolverImpl.info(message, parms);
    }

    private String adjustFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (this.isOpenLiberty()) {
            return fileName;
        }
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex == -1) {
            return fileName + WAS_LIBERTY_TAIL;
        }
        String baseName = fileName.substring(0, extensionIndex);
        String ext = fileName.substring(extensionIndex);
        return baseName + WAS_LIBERTY_TAIL + ext;
    }

    public static void generate(FeatureResolverImpl resolver, FeatureResolver.Repository repository, Set<String> allowedMultiple, Collection<ProvisioningFeatureDefinition> kernelFeatures) {
        String servletFileName;
        String singletonFileName;
        FeatureResolverBaseline baseline = new FeatureResolverBaseline(resolver, repository);
        String repoFileName = VerifyEnv.REPO_FILE_NAME;
        if (repoFileName != null) {
            baseline.writeRepository(baseline.adjustFileName(repoFileName));
        }
        if ((singletonFileName = VerifyEnv.RESULTS_SINGLETON_FILE_NAME) != null) {
            String durationsFileName = VerifyEnv.DURATIONS_SINGLETON_FILE_NAME;
            baseline.generateSingleton(allowedMultiple, kernelFeatures, baseline.adjustFileName(singletonFileName), baseline.adjustFileName(durationsFileName));
        }
        if ((servletFileName = VerifyEnv.RESULTS_SERVLET_FILE_NAME) != null) {
            String durationsFileName = VerifyEnv.DURATIONS_SERVLET_FILE_NAME;
            baseline.generatePairs(allowedMultiple, kernelFeatures, "Servlet and versionless (no MP)", "Servlet", "Versionless (no MP)", FeatureResolverBaseline.getServletFeatures(repository), FeatureResolverBaseline.getVersionlessFeatures(repository, true, false), baseline.adjustFileName(servletFileName), baseline.adjustFileName(durationsFileName));
        }
    }

    private FeatureResolverBaseline(FeatureResolverImpl resolver, FeatureResolver.Repository repository) {
        this.resolver = resolver;
        this.repository = repository;
    }

    public FeatureResolverImpl getResolver() {
        return this.resolver;
    }

    public FeatureResolver.Repository getRepository() {
        return this.repository;
    }

    private boolean isOpenLiberty() {
        return this.getRepository().getFeature(WAS_LIBERTY_FEATURE_NAME) == null;
    }

    private static List<String> getServletFeatures(FeatureResolver.Repository repository) {
        ArrayList<String> servletFeatures = new ArrayList<String>();
        for (ProvisioningFeatureDefinition featureDef : repository.getFeatures()) {
            String featureName = featureDef.getIbmShortName();
            if (featureName == null || !featureName.startsWith(SERVLET_VERSIONLESS_PREFIX)) continue;
            servletFeatures.add(featureName);
        }
        Collections.sort(servletFeatures);
        return servletFeatures;
    }

    private static List<String> getVersionlessFeatures(FeatureResolver.Repository repository, boolean includeEE, boolean includeMP) {
        ArrayList<String> versionlessFeatures = new ArrayList<String>();
        for (ProvisioningFeatureDefinition featureDef : repository.getFeatures()) {
            String addReason;
            String platformName;
            String featureName = featureDef.getSymbolicName();
            if (!featureName.startsWith(VERSIONLESS_PREFIX) || (platformName = featureDef.getPlatformName()) != null && platformName.equals("jakartaee-11.0") || (addReason = includeEE && includeMP ? "Include EE and MP" : (includeEE && !featureName.startsWith(VERSIONLESS_MP_PREFIX) ? "Include EE" : (includeMP && featureName.startsWith(VERSIONLESS_MP_PREFIX) ? "Include MP" : null))) == null) continue;
            versionlessFeatures.add(featureName);
        }
        Collections.sort(versionlessFeatures);
        return versionlessFeatures;
    }

    private void writeRepository(String repoFileName) {
        File repoFile = new File(repoFileName);
        String repoFilePath = repoFile.getAbsolutePath();
        FeatureResolverBaseline.info("Writing feature repository to [ " + repoFilePath + " ] ...", new Object[0]);
        try {
            RepoXML.write(new File(repoFileName), this.getRepository());
            FeatureResolverBaseline.info("Writing feature repository to [ " + repoFilePath + " ] ... done", new Object[0]);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline", (String)"253", (Object)this, (Object[])new Object[]{repoFileName});
            FeatureResolverBaseline.error("Error writing feature repository to [ " + repoFilePath + " ]", new Object[0]);
        }
    }

    private void writeCases(CaseGenerator generator, String resultsFileName, String durationsFileName) {
        FeatureResolverBaseline.info(generator.getDescription(), new Object[0]);
        File resultsFile = new File(resultsFileName);
        String resultsFilePath = resultsFile.getAbsolutePath();
        FeatureResolverBaseline.info("Resolving ...", new Object[0]);
        List<LazySupplierImpl<VerifyData.VerifyCase>> cases = generator.generate();
        FeatureResolverBaseline.info("Resolving ... done", new Object[0]);
        FeatureResolverBaseline.info("Writing to [ " + resultsFilePath + " ] ...", new Object[0]);
        try {
            VerifyXML.write(resultsFile, cases);
            FeatureResolverBaseline.info("Writing to [ " + resultsFilePath + " ] ... done", new Object[0]);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline", (String)"283", (Object)this, (Object[])new Object[]{generator, resultsFileName, durationsFileName});
            FeatureResolverBaseline.error("Failed writing to [ " + resultsFilePath + " ] ...", new Object[0]);
        }
        if (durationsFileName != null) {
            File durationsFile = new File(durationsFileName);
            String durationsFilePath = durationsFile.getAbsolutePath();
            FeatureResolverBaseline.info("Writing durations to [ " + durationsFilePath + " ] ...", new Object[0]);
            try {
                VerifyXML.writeDurations(durationsFile, cases);
                FeatureResolverBaseline.info("Writing durations to [ " + durationsFilePath + " ] ... done", new Object[0]);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline", (String)"296", (Object)this, (Object[])new Object[]{generator, resultsFileName, durationsFileName});
                FeatureResolverBaseline.error("Failed writing durations to [ " + durationsFilePath + " ] ...", new Object[0]);
            }
        }
        FeatureResolverBaseline.info(generator.getDescription() + " ... done", new Object[0]);
    }

    private void generateSingleton(final Set<String> allowedMultiple, final Collection<ProvisioningFeatureDefinition> kernelFeatures, String resultsFileName, String durationsFileName) {
        CaseGenerator generator = new CaseGenerator(){
            static final long serialVersionUID = -2820062263487591070L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String getDescription() {
                return "Test suite: All public features as singletons";
            }

            @Override
            public List<LazySupplierImpl<VerifyData.VerifyCase>> generate() {
                return FeatureResolverBaseline.this.generateSingleton(allowedMultiple, kernelFeatures);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
        this.writeCases(generator, resultsFileName, durationsFileName);
    }

    private void generatePairs(final Set<String> allowedMultiple, final Collection<ProvisioningFeatureDefinition> kernelFeatures, final String description, final String element0Description, final String element1Description, final List<String> elements0, final List<String> elements1, String resultsFileName, String durationsFileName) {
        CaseGenerator generator = new CaseGenerator(){
            static final long serialVersionUID = -6860163085198756046L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String getDescription() {
                return "Test suite: " + description;
            }

            @Override
            public List<LazySupplierImpl<VerifyData.VerifyCase>> generate() {
                return FeatureResolverBaseline.this.generatePairs(allowedMultiple, kernelFeatures, element0Description, element1Description, elements0, elements1);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline$2", 2.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
        this.writeCases(generator, resultsFileName, durationsFileName);
    }

    static List<ProvisioningFeatureDefinition> select(FeatureResolver.Repository repository, FeatureResolver.Selector<ProvisioningFeatureDefinition> selector) {
        return FeatureResolverBaseline.select(repository.getFeatures(), selector);
    }

    public static List<ProvisioningFeatureDefinition> select(List<ProvisioningFeatureDefinition> defs, FeatureResolver.Selector<ProvisioningFeatureDefinition> selector) {
        ArrayList<ProvisioningFeatureDefinition> selected = new ArrayList<ProvisioningFeatureDefinition>(defs.size());
        for (ProvisioningFeatureDefinition def : defs) {
            if (selector != null && !selector.test(def)) continue;
            selected.add(def);
        }
        return selected;
    }

    private List<LazySupplierImpl<VerifyData.VerifyCase>> generateSingleton(final Set<String> allowedMultiple, final Collection<ProvisioningFeatureDefinition> kernelFeatures) {
        FeatureResolver.Selector<ProvisioningFeatureDefinition> selector = RepoXML.featureSelector(true, false, false);
        List<ProvisioningFeatureDefinition> featureDefs = FeatureResolverBaseline.select(this.getRepository(), selector);
        int numDefs = featureDefs.size();
        ProvisioningFeatureDefinition[] defsArray = featureDefs.toArray(new ProvisioningFeatureDefinition[numDefs]);
        Arrays.sort(defsArray, COMPARE_SYMBOLIC);
        final Transformer<ProvisioningFeatureDefinition, VerifyData.VerifyCase> createResult = new Transformer<ProvisioningFeatureDefinition, VerifyData.VerifyCase>(){
            static final long serialVersionUID = 8544485226794724112L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public VerifyData.VerifyCase apply(ProvisioningFeatureDefinition rootDef) {
                return FeatureResolverBaseline.this.createSingletonResult(allowedMultiple, kernelFeatures, rootDef);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline$4", 4.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
        ArrayList<LazySupplierImpl<VerifyData.VerifyCase>> cases = new ArrayList<LazySupplierImpl<VerifyData.VerifyCase>>(numDefs);
        Iterator<ProvisioningFeatureDefinition> iterator = featureDefs.iterator();
        while (iterator.hasNext()) {
            ProvisioningFeatureDefinition def;
            final ProvisioningFeatureDefinition useDef = def = iterator.next();
            cases.add(new LazySupplierImpl<VerifyData.VerifyCase>(){
                static final long serialVersionUID = 5374296828388243027L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public VerifyData.VerifyCase produce() {
                    return (VerifyData.VerifyCase)createResult.apply(useDef);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline$5", 5.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                }
            });
        }
        return cases;
    }

    private List<LazySupplierImpl<VerifyData.VerifyCase>> generatePairs(final Set<String> allowedMultiple, final Collection<ProvisioningFeatureDefinition> kernelFeatures, final String element0Desc, final String element1Desc, List<String> elements0, List<String> elements1) {
        int num0 = elements0.size();
        int num1 = elements1.size();
        FeatureResolverBaseline.info(element0Desc + " features [ " + num0 + " ]", new Object[0]);
        for (String feature0 : elements0) {
            FeatureResolverBaseline.info("  [ " + feature0 + " ]", new Object[0]);
        }
        FeatureResolverBaseline.info(element1Desc + " features [ " + num1 + " ]", new Object[0]);
        for (String feature : elements1) {
            FeatureResolverBaseline.info("  [ " + feature + " ]", new Object[0]);
        }
        final BiTransformer<String, String, VerifyData.VerifyCase> createResult = new BiTransformer<String, String, VerifyData.VerifyCase>(){
            static final long serialVersionUID = -3956718909748775437L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public VerifyData.VerifyCase apply(String feature0, String feature1) {
                return FeatureResolverBaseline.this.createResult(allowedMultiple, kernelFeatures, element0Desc, element1Desc, feature0, feature1);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline$6", 6.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
        FeatureResolverBaseline.info("Total cases [ " + num0 * num1 + " ]", new Object[0]);
        ArrayList<LazySupplierImpl<VerifyData.VerifyCase>> cases = new ArrayList<LazySupplierImpl<VerifyData.VerifyCase>>(num0 * num1);
        for (String feature0 : elements0) {
            for (String feature1 : elements1) {
                final String useFeature0 = feature0;
                final String useFeature1 = feature1;
                cases.add(new LazySupplierImpl<VerifyData.VerifyCase>(){
                    static final long serialVersionUID = 3217926607557143010L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public VerifyData.VerifyCase produce() {
                        return (VerifyData.VerifyCase)createResult.apply(useFeature0, useFeature1);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline$7", 7.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                    }
                });
            }
        }
        return cases;
    }

    private VerifyData.VerifyCase createResult(Set<String> allowedMultiple, Collection<ProvisioningFeatureDefinition> kernelFeatures, String feature0Desc, String feature1Desc, String feature0, String feature1) {
        Set<String> preResolved = Collections.emptySet();
        Set<String> profiles = Collections.emptySet();
        ArrayList<String> rootFeatures = new ArrayList<String>(2);
        rootFeatures.add(feature0);
        rootFeatures.add(feature1);
        FeatureResolverBaseline.info("Creating test result ... ", new Object[0]);
        FeatureResolverBaseline.info("  " + feature0Desc + " feature [ " + feature0 + " ]", new Object[0]);
        FeatureResolverBaseline.info("  " + feature1Desc + " feature [ " + feature1 + " ]", new Object[0]);
        long startTimeNs = VerifyData.getTimeNs();
        FeatureResolver.Result resultWithKernel = this.getResolver().doResolve(this.getRepository(), kernelFeatures, rootFeatures, preResolved, allowedMultiple, EnumSet.allOf(ProcessType.class), profiles);
        Set<ProvisioningFeatureDefinition> emptyDefs = Collections.emptySet();
        FeatureResolver.Result resultWithoutKernel = this.getResolver().doResolve(this.getRepository(), emptyDefs, rootFeatures, preResolved, allowedMultiple, EnumSet.allOf(ProcessType.class), profiles);
        long endTimeNs = VerifyData.getTimeNs();
        long durationNs = endTimeNs - startTimeNs;
        FeatureResolverBaseline.info("Creating test result ... done [ " + Long.toString(durationNs) + " ns ]", new Object[0]);
        boolean allowMultiple = allowedMultiple != null;
        String name = feature0 + "_" + feature1 + (allowMultiple ? "_n" : "");
        String description = "Feature pair [ " + feature0 + ", " + feature1 + " ]" + (allowMultiple ? " [ Multiple ]" : "");
        return this.asCase(name, description, allowedMultiple, kernelFeatures, rootFeatures, resultWithKernel, resultWithoutKernel, durationNs);
    }

    private VerifyData.VerifyCase createSingletonResult(Set<String> allowedMultiple, Collection<ProvisioningFeatureDefinition> kernelFeatures, ProvisioningFeatureDefinition featureDef) {
        Set<String> rootFeatures = Collections.singleton(featureDef.getSymbolicName());
        Set<String> preResolved = Collections.emptySet();
        Set<String> profiles = Collections.emptySet();
        FeatureResolverBaseline.info("Creating singleton test result ... ", new Object[0]);
        long startTimeNs = VerifyData.getTimeNs();
        FeatureResolver.Result resultWithKernel = this.getResolver().doResolve(this.getRepository(), kernelFeatures, rootFeatures, preResolved, allowedMultiple, EnumSet.allOf(ProcessType.class), profiles);
        Set<ProvisioningFeatureDefinition> emptyDefs = Collections.emptySet();
        FeatureResolver.Result resultWithoutKernel = this.getResolver().doResolve(this.getRepository(), emptyDefs, rootFeatures, preResolved, allowedMultiple, EnumSet.allOf(ProcessType.class), profiles);
        long endTimeNs = VerifyData.getTimeNs();
        long durationNs = endTimeNs - startTimeNs;
        FeatureResolverBaseline.info("Creating singleton test result ... done [ " + Long.toString(durationNs) + " ns ]", new Object[0]);
        boolean allowMultiple = allowedMultiple != null;
        String name = featureDef.getSymbolicName() + (allowMultiple ? "_n" : "");
        String description = "Singleton [ " + featureDef.getSymbolicName() + " ]" + (allowMultiple ? " [ Multiple ]" : "");
        List<String> rootFeatureNames = Collections.singletonList(featureDef.getSymbolicName());
        return this.asCase(name, description, allowedMultiple, kernelFeatures, rootFeatureNames, resultWithKernel, resultWithoutKernel, durationNs);
    }

    public VerifyData.VerifyCase asCase(String name, String description, Set<String> allowedMultiple, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, FeatureResolver.Result resultWithKernel, FeatureResolver.Result resultWithoutKernel, long durationNs) {
        boolean allowMultiple = allowedMultiple != null;
        VerifyData.VerifyCase verifyCase = new VerifyData.VerifyCase(name, description, allowMultiple);
        verifyCase.durationNs = durationNs;
        for (ProvisioningFeatureDefinition kernelDef : kernelFeatures) {
            verifyCase.input.addKernel(kernelDef.getSymbolicName());
        }
        for (String rootFeature : rootFeatures) {
            verifyCase.input.addRoot(rootFeature);
        }
        verifyCase.output.copy(resultWithKernel);
        verifyCase.kernelAdjust(true, resultWithoutKernel.getResolvedFeatures(), false);
        return verifyCase;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline", FeatureResolverBaseline.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        COMPARE_SYMBOLIC = new Comparator<ProvisioningFeatureDefinition>(){
            static final long serialVersionUID = 1414328554838974128L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(ProvisioningFeatureDefinition def1, ProvisioningFeatureDefinition def2) {
                return def1.getSymbolicName().compareToIgnoreCase(def2.getSymbolicName());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline$3", 3.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
    }

    public static interface CaseGenerator {
        public String getDescription();

        public List<LazySupplierImpl<VerifyData.VerifyCase>> generate();
    }
}

