/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.usage.metering;

import com.ibm.wsspi.usage.metering.AggregationMethodDescriptor;
import com.ibm.wsspi.usage.metering.MetricGroupDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MetricDescriptor
extends AggregationMethodDescriptor<MetricDescriptor> {
    private final String type;
    private String name;
    private final Map<String, String> translatedNames;
    private String units;
    private Map<String, String> translatedUnits;
    private Number defaultValue;
    private Number minValue;
    private Number maxValue;
    private Set<MetricGroupDescriptor> metricGroupDescriptors;

    public MetricDescriptor(String type, Map<String, String> translatedNames) {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("Required metricType attribute not specified:" + type);
        }
        this.type = type;
        if (translatedNames == null || translatedNames.size() == 0) {
            throw new IllegalArgumentException("Required metricNames attribute not specified:" + translatedNames);
        }
        this.translatedNames = new HashMap<String, String>(translatedNames);
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getTranslatedNames() {
        return this.translatedNames;
    }

    public Map<String, String> getTranslatedUnits() {
        return this.translatedUnits;
    }

    public Number getDefaultValue() {
        return this.defaultValue;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public MetricDescriptor setTranslatedUnits(Map<String, String> translatedUnits) {
        this.translatedUnits = translatedUnits != null && translatedUnits.size() > 0 ? new HashMap<String, String>(translatedUnits) : null;
        return this;
    }

    public MetricDescriptor setDefaultValue(Number defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public MetricDescriptor setMinValue(Number minValue) {
        this.minValue = minValue;
        return this;
    }

    public MetricDescriptor setMaxValue(Number maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public MetricDescriptor addGroupDescriptor(MetricGroupDescriptor ... descriptors) {
        if (descriptors != null && descriptors.length > 0) {
            if (this.metricGroupDescriptors == null) {
                this.metricGroupDescriptors = new HashSet<MetricGroupDescriptor>();
            }
            this.metricGroupDescriptors.addAll(Arrays.asList(descriptors));
        }
        return this;
    }

    public Set<MetricGroupDescriptor> getGroupDescriptors() {
        return this.metricGroupDescriptors;
    }

    public MetricDescriptor setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod ... aggregationMethods) {
        super.setSliceAggregationMethods(aggregationMethods);
        return this;
    }

    public MetricDescriptor setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod ... aggregationMethods) {
        super.setRangeAggregationMethods(aggregationMethods);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MetricDescriptor setName(String name) {
        this.name = name;
        return this;
    }

    public String getUnits() {
        return this.units;
    }

    public MetricDescriptor setUnits(String units) {
        this.units = units;
        return this;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricDescriptor other = (MetricDescriptor)obj;
        return this.type.equals(other.type);
    }
}

