/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapRequestHandler;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionImpl;
import com.icegreen.greenmail.server.BuildInfo;
import com.icegreen.greenmail.server.ProtocolHandler;
import com.icegreen.greenmail.user.UserManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImapHandler
implements ImapConstants,
ProtocolHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ImapRequestHandler requestHandler = new ImapRequestHandler();
    private ImapSession session;
    private final Object closeMonitor = new Object();
    private Socket socket;
    private ImapResponse response;
    UserManager userManager;
    private ImapHostManager imapHost;

    public ImapHandler(UserManager userManager, ImapHostManager imapHost, Socket socket) {
        this.userManager = userManager;
        this.imapHost = imapHost;
        this.socket = socket;
    }

    public void forceConnectionClose(String message) {
        this.response.byeResponse(message);
        this.close();
    }

    @Override
    public void run() {
        try (BufferedInputStream ins = new BufferedInputStream(this.socket.getInputStream(), 512);
             BufferedOutputStream outs = new BufferedOutputStream(this.socket.getOutputStream(), 1024);){
            this.response = new ImapResponse(outs);
            String responseBuffer = "IMAP4rev1 Server GreenMail v" + BuildInfo.INSTANCE.getProjectVersion() + " ready";
            this.response.okResponse(null, responseBuffer);
            this.session = new ImapSessionImpl(this.imapHost, this.userManager, this, this.socket.getInetAddress().getHostAddress());
            while (this.requestHandler.handleRequest(ins, outs, this.session)) {
            }
        }
        catch (Exception e) {
            this.log.error("Can not handle IMAP connection", e);
            throw new IllegalStateException("Can not handle IMAP connection", e);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.closeMonitor;
        synchronized (object) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    this.log.warn("Can not close socket", e);
                }
                finally {
                    this.socket = null;
                }
            }
            this.session = null;
            this.response = null;
        }
    }
}

