/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.util.DummyTrustManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Random;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummySSLSocketFactory
extends SSLSocketFactory {
    protected static final Logger log = LoggerFactory.getLogger(DummySSLSocketFactory.class);
    private SSLSocketFactory factory;

    public DummySSLSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new DummyTrustManager()}, null);
            this.factory = sslcontext.getSocketFactory();
        }
        catch (Exception ex) {
            log.error("Can not create and initialize SSL", ex);
            throw new IllegalStateException("Can not create and initialize SSL", ex);
        }
    }

    public static SocketFactory getDefault() {
        return new DummySSLSocketFactory();
    }

    private Socket addAnonCipher(Socket socket) {
        SSLSocket ssl = (SSLSocket)socket;
        String[] ciphers = ssl.getEnabledCipherSuites();
        String[] anonCiphers = new String[]{"SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
        String[] newCiphers = new String[ciphers.length + anonCiphers.length];
        System.arraycopy(ciphers, 0, newCiphers, 0, ciphers.length);
        System.arraycopy(anonCiphers, 0, newCiphers, ciphers.length, anonCiphers.length);
        ssl.setEnabledCipherSuites(newCiphers);
        return ssl;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.factory.createSocket();
        DummySSLSocketFactory.trySetFakeRemoteHost(socket);
        return this.addAnonCipher(socket);
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(socket, s, i, flag));
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(inaddr, i, inaddr1, j));
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(inaddr, i));
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(s, i, inaddr, j));
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(s, i));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    private static void trySetFakeRemoteHost(Socket socket) {
        try {
            Method setHostMethod = socket.getClass().getMethod("setHost", String.class);
            String fakeHostName = "greenmailHost" + new BigInteger(130, new Random()).toString(32);
            setHostMethod.invoke((Object)socket, fakeHostName);
        }
        catch (NoSuchMethodException e) {
            log.debug("Could not set fake remote host. SSL connection setup may be slow.");
        }
        catch (InvocationTargetException e) {
            log.debug("Could not set fake remote host. SSL connection setup may be slow.");
        }
        catch (IllegalAccessException e) {
            log.debug("Could not set fake remote host. SSL connection setup may be slow.");
        }
    }
}

