/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SearchKey;
import com.icegreen.greenmail.imap.commands.SearchTermBuilder;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import javax.mail.search.AndTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchCommandParser
extends CommandParser {
    private final Logger log = LoggerFactory.getLogger(SearchCommandParser.class);
    private static final String CHARSET_TOKEN = "CHARSET";

    SearchCommandParser() {
    }

    public SearchTerm searchTerm(ImapRequestLineReader request) throws ProtocolException, CharacterCodingException {
        Object resultTerm = null;
        SearchTermBuilder b = null;
        SearchKey key = null;
        boolean orKey = false;
        boolean negated = false;
        char next = request.nextChar();
        StringBuilder sb = new StringBuilder();
        boolean quoted = false;
        Charset charset = null;
        while (next != '\n') {
            if (next != '\"' && (quoted || next != '\"' && next != ' ' && next != '\r')) {
                sb.append(next);
            }
            request.consume();
            next = request.nextChar();
            if (next == '\"' && (quoted = !quoted) || quoted || next != ' ' && next != '\n' || sb.length() <= 0) continue;
            this.log.debug("Search request is '{}'", (Object)sb);
            if (null == b) {
                try {
                    String keyValue = sb.toString();
                    if (keyValue.charAt(0) == '(' && keyValue.charAt(keyValue.length() - 1) == ')') {
                        keyValue = keyValue.substring(1, keyValue.length() - 1);
                    }
                    if (IdRange.SEQUENCE.matcher(keyValue).matches()) {
                        b = SearchTermBuilder.create(SearchKey.SEQUENCE_SET);
                        next = request.nextChar();
                        while (next == ' ' || Character.isDigit(next) || next == ':') {
                            request.consume();
                            sb.append(next);
                            next = request.nextChar();
                        }
                        b.addParameter(sb.toString());
                    } else if (CHARSET_TOKEN.equals(keyValue)) {
                        request.nextWordChar();
                        String c = this.astring(request);
                        this.log.debug("Searching with given CHARSET <{}>", (Object)c);
                        charset = Charset.forName(c);
                    } else {
                        key = SearchKey.valueOf(keyValue);
                        if (SearchKey.NOT == key) {
                            negated = true;
                        } else {
                            b = SearchTermBuilder.create(key);
                        }
                        if (null != b && b.expectsParameter() && key.isCharsetAware() && null != charset && next == ' ' && (next = request.nextWordChar()) == '{') {
                            String textOfCharset = new String(this.consumeLiteralAsBytes(request), charset);
                            b.addParameter(textOfCharset);
                            this.log.debug("Searching for text <{}> of charset {}", (Object)textOfCharset, (Object)charset);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    this.log.warn("Ignoring not yet implemented search command '{}'", (Object)sb, (Object)ex);
                    negated = false;
                }
            } else if (b.expectsParameter()) {
                if (b.isCharsetAware() && null != charset) {
                    request.consume();
                    next = request.nextChar();
                    Integer capacity = Integer.valueOf(sb.substring(1, sb.length() - 1));
                    ByteBuffer bb = ByteBuffer.allocate(capacity);
                    while (next != '\r') {
                        request.consume();
                        sb.append(next);
                        next = request.nextChar();
                    }
                    String decoded = charset.decode(bb).toString();
                    this.log.info("Decoded <{}> into <{}>", (Object)bb, (Object)decoded);
                    b = b.addParameter(decoded);
                } else {
                    b = b.addParameter(sb.toString());
                }
            }
            if (b != null && !b.expectsParameter()) {
                SearchTerm searchTerm = b.build();
                if (negated) {
                    searchTerm = new NotTerm(searchTerm);
                    negated = false;
                }
                b = null;
                if (SearchKey.OR == key) {
                    resultTerm = resultTerm == null ? searchTerm : new OrTerm(resultTerm, searchTerm);
                    orKey = true;
                } else {
                    resultTerm = orKey ? (SearchKey.ALL == key ? (resultTerm == null ? searchTerm : new AndTerm(resultTerm, searchTerm)) : (resultTerm == null ? searchTerm : new OrTerm(resultTerm, searchTerm))) : (resultTerm == null ? searchTerm : new AndTerm(resultTerm, searchTerm));
                }
            }
            sb.setLength(0);
            next = request.nextChar();
        }
        return resultTerm;
    }
}

