/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.mail;

import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.mail.internet.MimeMessage;

public class MovingMessage {
    private MailAddress returnPath;
    private List<MailAddress> toAddresses = new LinkedList<MailAddress>();
    private MimeMessage message;
    private String content;

    public List<MailAddress> getToAddresses() {
        return this.toAddresses;
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public Reader getContent() {
        return new StringReader(this.content);
    }

    public void releaseContent() {
        this.content = "";
    }

    public MailAddress getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(MailAddress fromAddress) {
        this.returnPath = fromAddress;
    }

    public void addRecipient(MailAddress s) {
        this.toAddresses.add(s);
    }

    public void removeRecipient(MailAddress s) {
        this.toAddresses.remove(s);
    }

    public void readDotTerminatedContent(BufferedReader in) throws IOException {
        StringBuilder buf = new StringBuilder();
        while (true) {
            String line;
            if ((line = in.readLine()) == null) {
                throw new EOFException("Did not receive <CRLF>.<CRLF>");
            }
            if (".".equals(line)) break;
            if (line.startsWith(".")) {
                this.println(buf, line.substring(1));
                continue;
            }
            this.println(buf, line);
        }
        this.content = buf.toString();
        try {
            this.message = GreenMailUtil.newMimeMessage(this.content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void println(StringBuilder buf, String line) {
        buf.append(line).append("\r\n");
    }
}

