/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.compiler;

import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Utils {
    public static final String FORM_NAMESPACE = "http://www.intellij.com/uidesigner/form/";
    private static final SAXParser SAX_PARSER = Utils.createParser();
    private static final SAXBuilder SAX_BUILDER = new SAXBuilder();
    static /* synthetic */ Class class$javax$swing$JComponent;

    private static SAXParser createParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LwRootContainer getRootContainer(String formFileContent, PropertiesProvider provider) throws Exception {
        if (formFileContent.indexOf(FORM_NAMESPACE) == -1) {
            throw new AlienFormFileException();
        }
        Document document = SAX_BUILDER.build((Reader)new StringReader(formFileContent), "UTF-8");
        LwRootContainer root = new LwRootContainer();
        root.read(document.getRootElement(), provider);
        return root;
    }

    public static synchronized String getBoundClassName(String formFileContent) throws Exception {
        if (formFileContent.indexOf(FORM_NAMESPACE) == -1) {
            throw new AlienFormFileException();
        }
        final String[] className = new String[]{null};
        try {
            SAX_PARSER.parse(new InputSource(new StringReader(formFileContent)), new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("form".equals(qName)) {
                        className[0] = attributes.getValue("", "bind-to-class");
                        throw new SAXException("stop parsing");
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return className[0];
    }

    public static String validateJComponentClass(ClassLoader loader, String className) {
        Class<?> aClass;
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        if ("com.intellij.uiDesigner.HSpacer".equals(className) || "com.intellij.uiDesigner.VSpacer".equals(className)) {
            return null;
        }
        try {
            aClass = Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException exc) {
            return "Class \"" + className + "\"not found";
        }
        catch (NoClassDefFoundError exc) {
            return "Cannot load class " + className + ": " + exc.getMessage();
        }
        try {
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            if ((constructor.getModifiers() & 0) != 0) {
                return "Class \"" + className + "\" does not have default public constructor";
            }
        }
        catch (Exception exc) {
            return "Class \"" + className + "\" does not have default constructor";
        }
        if (!(class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = Utils.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isAssignableFrom(aClass)) {
            return "Class \"" + className + "\" is not an instance of javax.swing.JComponent";
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

