/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.core;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.LayoutState;
import com.intellij.uiDesigner.core.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;

public abstract class DimensionInfo {
    private final int[] myCell;
    private final int[] mySpan;
    protected final LayoutState myLayoutState;
    private final int[] myStretches;
    private final int[] mySpansAfterElimination;
    private final int[] myCellSizePolicies;
    private final int myGap;

    public DimensionInfo(LayoutState layoutState, int gap) {
        if (layoutState == null) {
            throw new IllegalArgumentException("layoutState cannot be null");
        }
        if (gap < 0) {
            throw new IllegalArgumentException("invalid gap: " + gap);
        }
        this.myLayoutState = layoutState;
        this.myGap = gap;
        this.myCell = new int[layoutState.getComponentCount()];
        this.mySpan = new int[layoutState.getComponentCount()];
        int i = 0;
        while (i < layoutState.getComponentCount()) {
            GridConstraints c = layoutState.getConstraints(i);
            this.myCell[i] = this.getOriginalCell(c);
            this.mySpan[i] = this.getOriginalSpan(c);
            ++i;
        }
        this.myStretches = new int[this.getCellCount()];
        int i2 = 0;
        while (i2 < this.myStretches.length) {
            this.myStretches[i2] = 1;
            ++i2;
        }
        ArrayList elimitated = new ArrayList();
        this.mySpansAfterElimination = (int[])this.mySpan.clone();
        Util.eliminate((int[])this.myCell.clone(), this.mySpansAfterElimination, elimitated);
        this.myCellSizePolicies = new int[this.getCellCount()];
        int i3 = 0;
        while (i3 < this.myCellSizePolicies.length) {
            this.myCellSizePolicies[i3] = this.getCellSizePolicyImpl(i3, elimitated);
            ++i3;
        }
    }

    public final int getComponentCount() {
        return this.myLayoutState.getComponentCount();
    }

    public final Component getComponent(int componentIndex) {
        return this.myLayoutState.getComponent(componentIndex);
    }

    public abstract int getCellCount();

    public abstract int getPreferredWidth(int var1);

    public abstract int getMinimumWidth(int var1);

    public final int getCell(int componentIndex) {
        return this.myCell[componentIndex];
    }

    public final int getSpan(int componentIndex) {
        return this.mySpan[componentIndex];
    }

    public final int getStretch(int cellIndex) {
        return this.myStretches[cellIndex];
    }

    protected abstract int getOriginalCell(GridConstraints var1);

    protected abstract int getOriginalSpan(GridConstraints var1);

    abstract int getSizePolicy(int var1);

    public final int getGap() {
        return this.myGap;
    }

    private boolean componentBelongsCell(int componentIndex, int cellIndex) {
        int componentStartCell = this.getCell(componentIndex);
        int span = this.getSpan(componentIndex);
        return componentStartCell <= cellIndex && cellIndex < componentStartCell + span;
    }

    public final int getCellSizePolicy(int cellIndex) {
        return this.myCellSizePolicies[cellIndex];
    }

    private int getCellSizePolicyImpl(int cellIndex, ArrayList eliminatedCells) {
        int i = eliminatedCells.size() - 1;
        while (i >= 0) {
            if (cellIndex == (Integer)eliminatedCells.get(i)) {
                return 1;
            }
            --i;
        }
        boolean canShrink = true;
        boolean canGrow = false;
        boolean wantGrow = false;
        boolean weakCanGrow = true;
        boolean weakWantGrow = true;
        int countOfBelongingComponents = 0;
        int i2 = 0;
        while (i2 < this.getComponentCount()) {
            if (this.componentBelongsCell(i2, cellIndex)) {
                boolean thisWantGrow;
                ++countOfBelongingComponents;
                int p = this.getSizePolicy(i2);
                boolean thisCanShrink = (p & 1) != 0;
                boolean thisCanGrow = (p & 2) != 0;
                boolean bl = thisWantGrow = (p & 4) != 0;
                if (this.getCell(i2) == cellIndex && this.mySpansAfterElimination[i2] == 1) {
                    canShrink &= thisCanShrink;
                    canGrow |= thisCanGrow;
                    wantGrow |= thisWantGrow;
                }
                if (!thisCanGrow) {
                    weakCanGrow = false;
                }
                if (!thisWantGrow) {
                    weakWantGrow = false;
                }
            }
            ++i2;
        }
        return (canShrink ? 1 : 0) | (canGrow || countOfBelongingComponents > 0 && weakCanGrow ? 2 : 0) | (wantGrow || countOfBelongingComponents > 0 && weakWantGrow ? 4 : 0);
    }

    protected final Dimension getPreferredSize(int componentIndex) {
        Dimension size = this.myLayoutState.myPreferredSizes[componentIndex];
        if (size == null) {
            this.myLayoutState.myPreferredSizes[componentIndex] = size = Util.getPreferredSize(this.myLayoutState.getComponent(componentIndex), this.myLayoutState.getConstraints(componentIndex));
        }
        return size;
    }

    protected final Dimension getMinimumSize(int componentIndex) {
        Dimension size = this.myLayoutState.myMinimumSizes[componentIndex];
        if (size == null) {
            this.myLayoutState.myMinimumSizes[componentIndex] = size = Util.getMinimumSize(this.myLayoutState.getComponent(componentIndex), this.myLayoutState.getConstraints(componentIndex));
        }
        return size;
    }
}

