/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.core;

import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class SupportCode {
    static /* synthetic */ Class class$java$lang$String;

    public static TextWithMnemonic parseText(String textWithMnemonic) {
        if (textWithMnemonic == null) {
            throw new IllegalArgumentException("textWithMnemonic cannot be null");
        }
        int index = -1;
        StringBuffer plainText = new StringBuffer();
        int i = 0;
        while (i < textWithMnemonic.length()) {
            char ch = textWithMnemonic.charAt(i);
            if (ch == '&') {
                if (++i >= textWithMnemonic.length()) break;
                ch = textWithMnemonic.charAt(i);
                if (ch != '&') {
                    index = plainText.length();
                }
            }
            plainText.append(ch);
            ++i;
        }
        return new TextWithMnemonic(plainText.toString(), index);
    }

    public static void setTextFromBundle(JComponent component, String bundleName, String key) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (bundleName == null) {
            throw new IllegalArgumentException("bundleName cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        String text = SupportCode.getResourceString(bundleName, key);
        TextWithMnemonic textWithMnemonic = SupportCode.parseText(text);
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            label.setText(textWithMnemonic.myText);
            if (textWithMnemonic.myMnemonicIndex != -1) {
                label.setDisplayedMnemonic(textWithMnemonic.getMnemonicChar());
                SupportCode.setDisplayedMnemonicIndex(label, textWithMnemonic.myMnemonicIndex);
            }
        } else if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            button.setText(textWithMnemonic.myText);
            if (textWithMnemonic.myMnemonicIndex != -1) {
                button.setMnemonic(textWithMnemonic.getMnemonicChar());
                SupportCode.setDisplayedMnemonicIndex(button, textWithMnemonic.myMnemonicIndex);
            }
        } else {
            throw new IllegalArgumentException("unexpected class: " + component.getClass());
        }
    }

    public static void setTextFromBundle(JComponent component, String setterName, String bundle, String key) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (setterName == null) {
            throw new IllegalArgumentException("setterName cannot be null");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("bundle cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        String text = SupportCode.getResourceString(bundle, key);
        TextWithMnemonic textWithMnemonic = SupportCode.parseText(text);
        try {
            Method setter = component.getClass().getMethod(setterName, class$java$lang$String == null ? (class$java$lang$String = SupportCode.class$("java.lang.String")) : class$java$lang$String);
            setter.invoke((Object)component, textWithMnemonic.myText);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        if (textWithMnemonic.myMnemonicIndex != -1 && setterName.equals("setText")) {
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                label.setDisplayedMnemonic(textWithMnemonic.getMnemonicChar());
                SupportCode.setDisplayedMnemonicIndex(label, textWithMnemonic.myMnemonicIndex);
            } else if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setMnemonic(textWithMnemonic.getMnemonicChar());
                SupportCode.setDisplayedMnemonicIndex(button, textWithMnemonic.myMnemonicIndex);
            }
        }
    }

    public static void setDisplayedMnemonicIndex(JComponent component, int index) {
        try {
            Method method = component.getClass().getMethod("setDisplayedMnemonicIndex", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)component, new Integer(index));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getResourceString(String bundleName, String key) {
        return ResourceBundle.getBundle(bundleName).getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class TextWithMnemonic {
        public final String myText;
        public final int myMnemonicIndex;

        private TextWithMnemonic(String text, int index) {
            if (text == null) {
                throw new IllegalArgumentException("text cannot be null");
            }
            if (index != -1 && (index < 0 || index >= text.length())) {
                throw new IllegalArgumentException("wrong index: " + index + "; text = '" + text + "'");
            }
            this.myText = text;
            this.myMnemonicIndex = index;
        }

        public char getMnemonicChar() {
            if (this.myMnemonicIndex == -1) {
                throw new IllegalStateException("text doesn't contain mnemonic");
            }
            return Character.toUpperCase(this.myText.charAt(this.myMnemonicIndex));
        }
    }
}

