/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.shared;

import javax.swing.BorderFactory;
import javax.swing.border.Border;

public final class BorderType {
    public static final BorderType NONE = new BorderType("none", "None", null, null);
    public static final BorderType BEVEL_LOWERED = new BorderType("bevel-lowered", "Bevel Lowered", BorderFactory.createLoweredBevelBorder(), "createLoweredBevelBorder");
    public static final BorderType BEVEL_RAISED = new BorderType("bevel-raised", "Bevel Raised", BorderFactory.createRaisedBevelBorder(), "createRaisedBevelBorder");
    public static final BorderType ETCHED = new BorderType("etched", "Etched", BorderFactory.createEtchedBorder(), "createEtchedBorder");
    private final String myId;
    private final String myName;
    private final Border myBorder;
    private final String myBorderFactoryMethodName;

    private BorderType(String id, String name, Border border, String borderFactoryMethodName) {
        this.myId = id;
        this.myName = name;
        this.myBorder = border;
        this.myBorderFactoryMethodName = borderFactoryMethodName;
    }

    public String getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public Border createBorder(String title) {
        if (title != null) {
            return BorderFactory.createTitledBorder(this.myBorder, title);
        }
        return this.myBorder;
    }

    public String getBorderFactoryMethodName() {
        return this.myBorderFactoryMethodName;
    }

    public boolean equals(Object o) {
        if (o instanceof BorderType) {
            return this.myId.equals(((BorderType)o).myId);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public static BorderType valueOf(String name) {
        if (NONE.getId().equals(name)) {
            return NONE;
        }
        if (BEVEL_LOWERED.getId().equals(name)) {
            return BEVEL_LOWERED;
        }
        if (BEVEL_RAISED.getId().equals(name)) {
            return BEVEL_RAISED;
        }
        if (ETCHED.getId().equals(name)) {
            return ETCHED;
        }
        throw new IllegalArgumentException("unknown type: " + name);
    }
}

