/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.AssertionResult;
import com.intuit.karate.AssignType;
import com.intuit.karate.CallContext;
import com.intuit.karate.CallResult;
import com.intuit.karate.Config;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.ScriptBindings;
import com.intuit.karate.ScriptEvalContext;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.MatchType;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.validator.ArrayValidator;
import com.intuit.karate.validator.BooleanValidator;
import com.intuit.karate.validator.IgnoreValidator;
import com.intuit.karate.validator.NotNullValidator;
import com.intuit.karate.validator.NullValidator;
import com.intuit.karate.validator.NumberValidator;
import com.intuit.karate.validator.ObjectValidator;
import com.intuit.karate.validator.RegexValidator;
import com.intuit.karate.validator.StringValidator;
import com.intuit.karate.validator.UuidValidator;
import com.intuit.karate.validator.ValidationResult;
import com.intuit.karate.validator.Validator;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Script {
    public static final String VAR_SELF = "_";
    public static final String VAR_ROOT = "$";
    public static final String VAR_PARENT = "_$";
    public static final String VAR_LOOP = "__loop";
    public static final String VAR_ARG = "__arg";
    public static final String VAR_HEADER = "header";
    public static final Map<String, Validator> VALIDATORS = new HashMap<String, Validator>(10);
    private static final Pattern VAR_AND_PATH_PATTERN;
    private static final String VARIABLE_PATTERN_STRING = "[a-zA-Z][\\w]*";
    private static final Pattern VARIABLE_PATTERN;
    private static final String TOKEN = "token";
    private static final String PATH = "path";

    private Script() {
    }

    public static final boolean isCallSyntax(String text) {
        return text.startsWith("call ");
    }

    public static final boolean isCallOnceSyntax(String text) {
        return text.startsWith("callonce ");
    }

    public static final boolean isGetSyntax(String text) {
        return text.startsWith("get ") || text.startsWith("get[");
    }

    public static final boolean isJson(String text) {
        return text.startsWith("{") || text.startsWith("[");
    }

    public static final boolean isXml(String text) {
        return text.startsWith("<");
    }

    public static final boolean isXmlPath(String text) {
        return text.startsWith("/");
    }

    public static final boolean isXmlPathFunction(String text) {
        return text.matches("^[a-z-]+\\(.+");
    }

    public static final boolean isEmbeddedExpression(String text) {
        return (text.startsWith("#(") || text.startsWith("##(")) && text.endsWith(")");
    }

    public static final boolean isWithinParentheses(String text) {
        return text.startsWith("(") && text.endsWith(")");
    }

    public static final boolean isContainsMacro(String text) {
        return text.startsWith("^");
    }

    public static final boolean isContainsOnlyMacro(String text) {
        return text.startsWith("^^");
    }

    public static final boolean isContainsAnyMacro(String text) {
        return text.startsWith("^*");
    }

    public static final boolean isNotContainsMacro(String text) {
        return text.startsWith("!^");
    }

    public static final boolean isJsonPath(String text) {
        return text.startsWith("$.") || text.startsWith("$[") || text.equals(VAR_ROOT);
    }

    public static final boolean isDollarPrefixed(String text) {
        return text.startsWith(VAR_ROOT);
    }

    public static final boolean isVariable(String text) {
        return VARIABLE_PATTERN.matcher(text).matches();
    }

    public static final boolean isVariableAndSpaceAndPath(String text) {
        return text.matches("^[a-zA-Z][\\w]*\\s+.+");
    }

    public static StringUtils.Pair parseVariableAndPath(String text) {
        Matcher matcher = VAR_AND_PATH_PATTERN.matcher(text);
        matcher.find();
        String name = text.substring(0, matcher.end());
        String path = matcher.end() == text.length() ? "" : text.substring(matcher.end());
        if (!Script.isXmlPath(path) && !Script.isXmlPathFunction(path)) {
            path = VAR_ROOT + path;
        }
        return StringUtils.pair(name, path);
    }

    public static ScriptValue evalKarateExpressionForMatch(String text, ScenarioContext context) {
        return Script.evalKarateExpression(text, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptValue callWithCache(String text, String arg, ScenarioContext context, boolean reuseParentConfig) {
        FeatureContext featureContext = context.featureContext;
        CallResult result = featureContext.callCache.get(text);
        if (result != null) {
            context.logger.trace("callonce cache hit for: {}", text);
            if (reuseParentConfig) {
                context.configure(new Config(result.config));
            }
            return result.value.copy(false);
        }
        long startTime = System.currentTimeMillis();
        context.logger.trace("callonce waiting for lock: {}", text);
        FeatureContext featureContext2 = featureContext;
        synchronized (featureContext2) {
            result = featureContext.callCache.get(text);
            if (result != null) {
                long endTime = System.currentTimeMillis() - startTime;
                context.logger.warn("this thread waited {} milliseconds for callonce lock: {}", endTime, text);
                if (reuseParentConfig) {
                    context.configure(new Config(result.config));
                }
                return result.value.copy(false);
            }
            context.logger.info(">> lock acquired, begin callonce: {}", text);
            ScriptValue resultValue = Script.call(text, arg, context, reuseParentConfig);
            result = new CallResult(resultValue.copy(false), new Config(context.getConfig()));
            featureContext.callCache.put(text, result);
            context.logger.info("<< lock released, cached callonce: {}", text);
            return resultValue;
        }
    }

    public static ScriptValue getIfVariableReference(String text, ScenarioContext context) {
        ScriptValue value;
        if (Script.isVariable(text) && (value = (ScriptValue)context.vars.get(text)) != null) {
            return value;
        }
        return null;
    }

    public static ScriptValue evalKarateExpression(String text, ScenarioContext context) {
        if ((text = StringUtils.trimToNull(text)) == null) {
            return ScriptValue.NULL;
        }
        ScriptValue varValue = Script.getIfVariableReference(text, context);
        if (varValue != null) {
            return varValue;
        }
        boolean callOnce = Script.isCallOnceSyntax(text);
        if (callOnce || Script.isCallSyntax(text)) {
            text = callOnce ? text.substring(9) : text.substring(5);
            StringUtils.Pair pair = Script.parseCallArgs(text);
            if (callOnce) {
                return Script.callWithCache(pair.left, pair.right, context, false);
            }
            return Script.call(pair.left, pair.right, context, false);
        }
        if (Script.isJsonPath(text)) {
            return Script.evalJsonPathOnVarByName("response", text, context);
        }
        if (Script.isGetSyntax(text) || Script.isDollarPrefixed(text)) {
            List list;
            String right;
            String left;
            int index = -1;
            if (text.startsWith(VAR_ROOT)) {
                text = text.substring(1);
            } else if (text.startsWith("get[")) {
                int pos = text.indexOf(93);
                index = Integer.valueOf(text.substring(4, pos));
                text = text.substring(pos + 2);
            } else {
                text = text.substring(4);
            }
            if (Script.isJsonPath(text)) {
                left = "response";
                right = text;
            } else if (Script.isVariableAndSpaceAndPath(text)) {
                int pos = text.indexOf(32);
                right = text.substring(pos + 1);
                left = text.substring(0, pos);
            } else {
                StringUtils.Pair pair = Script.parseVariableAndPath(text);
                left = pair.left;
                right = pair.right;
            }
            ScriptValue sv = Script.isXmlPath(right) || Script.isXmlPathFunction(right) ? Script.evalXmlPathOnVarByName(left, right, context) : Script.evalJsonPathOnVarByName(left, right, context);
            if (index != -1 && sv.isListLike() && !(list = sv.getAsList()).isEmpty()) {
                return new ScriptValue(list.get(index));
            }
            return sv;
        }
        if (Script.isJson(text)) {
            DocumentContext doc = JsonUtils.toJsonDoc(text);
            Script.evalJsonEmbeddedExpressions(doc, context);
            return new ScriptValue(doc);
        }
        if (Script.isXml(text)) {
            Document doc = XmlUtils.toXmlDoc(text);
            Script.evalXmlEmbeddedExpressions(doc, context);
            return new ScriptValue(doc);
        }
        if (Script.isXmlPath(text)) {
            return Script.evalXmlPathOnVarByName("response", text, context);
        }
        return Script.evalJsExpression(text, context);
    }

    private static ScriptValue getValuebyName(String name, ScenarioContext context) {
        ScriptValue value = (ScriptValue)context.vars.get(name);
        if (value == null) {
            throw new RuntimeException("no variable found with name: " + name);
        }
        return value;
    }

    public static ScriptValue evalXmlPathOnVarByName(String name, String path, ScenarioContext context) {
        Node node;
        ScriptValue value = Script.getValuebyName(name, context);
        switch (value.getType()) {
            case XML: {
                node = value.getValue(Node.class);
                break;
            }
            default: {
                node = XmlUtils.fromMap(value.getAsMap());
            }
        }
        ScriptValue sv = Script.evalXmlPathOnXmlNode(node, path);
        if (sv == null) {
            throw new KarateException("xpath does not exist: " + path + " on " + name);
        }
        return sv;
    }

    public static ScriptValue evalXmlPathOnXmlNode(Node doc, String path) {
        NodeList nodeList;
        try {
            nodeList = XmlUtils.getNodeListByPath(doc, path);
        }
        catch (Exception e) {
            String strValue = XmlUtils.getTextValueByPath(doc, path);
            return new ScriptValue(strValue);
        }
        int count = nodeList.getLength();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return Script.nodeToValue(nodeList.item(0));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            ScriptValue sv = Script.nodeToValue(nodeList.item(i));
            list.add(sv.getValue());
        }
        return new ScriptValue(list);
    }

    private static ScriptValue nodeToValue(Node node) {
        int childElementCount = XmlUtils.getChildElementCount(node);
        if (childElementCount == 0) {
            return new ScriptValue(node.getTextContent());
        }
        if (node.getNodeType() == 9) {
            return new ScriptValue(node);
        }
        return new ScriptValue(XmlUtils.toNewDocument(node));
    }

    public static ScriptValue evalJsonPathOnVarByName(String name, String exp, ScenarioContext context) {
        ScriptValue value = Script.getValuebyName(name, context);
        if (value.isJsonLike()) {
            DocumentContext jsonDoc = value.getAsJsonDocument();
            return new ScriptValue(jsonDoc.read(exp, new Predicate[0]));
        }
        if (value.isXml()) {
            Document xml = value.getValue(Document.class);
            DocumentContext xmlDoc = XmlUtils.toJsonDoc(xml);
            return new ScriptValue(xmlDoc.read(exp, new Predicate[0]));
        }
        String str = value.getAsString();
        DocumentContext strDoc = JsonPath.parse((String)str);
        return new ScriptValue(strDoc.read(exp, new Predicate[0]));
    }

    public static ScriptValue evalJsExpression(String exp, ScenarioContext context) {
        return ScriptBindings.evalInNashorn(exp, context, null);
    }

    public static ScriptValue evalJsExpression(String exp, ScenarioContext context, ScriptValue selfValue, Object root, Object parent) {
        return ScriptBindings.evalInNashorn(exp, context, new ScriptEvalContext(selfValue, root, parent));
    }

    public static boolean isValidVariableName(String name) {
        return VARIABLE_PATTERN.matcher(name).matches();
    }

    public static void evalJsonEmbeddedExpressions(DocumentContext doc, ScenarioContext context) {
        Object o = doc.read(VAR_ROOT, new Predicate[0]);
        Script.evalJsonEmbeddedExpressions(VAR_ROOT, o, context, doc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void evalJsonEmbeddedExpressions(String path, Object o, ScenarioContext context, DocumentContext root) {
        if (o == null) {
            return;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            ArrayList keys = new ArrayList(map.keySet());
            for (String key : keys) {
                String childPath = JsonUtils.buildPath(path, key);
                Script.evalJsonEmbeddedExpressions(childPath, map.get(key), context, root);
            }
            return;
        } else if (o instanceof List) {
            List list = (List)o;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object child = list.get(i);
                String childPath = path + "[" + i + "]";
                Script.evalJsonEmbeddedExpressions(childPath, child, context, root);
            }
            return;
        } else {
            if (!(o instanceof String)) return;
            String value = (String)o;
            if (!Script.isEmbeddedExpression(value = StringUtils.trimToEmpty(value))) return;
            boolean optional = Script.isOptionalMacro(value);
            try {
                ScriptValue sv = Script.evalJsExpression(value.substring(optional ? 2 : 1), context);
                if (optional) {
                    if (sv.isNull()) {
                        root.delete(path, new Predicate[0]);
                        return;
                    }
                    if (sv.isJsonLike()) return;
                    root.set(path, sv.isStream() ? sv.getAsString() : sv.getValue(), new Predicate[0]);
                    return;
                }
                root.set(path, sv.isStream() ? sv.getAsString() : sv.getValue(), new Predicate[0]);
                return;
            }
            catch (Exception e) {
                context.logger.trace("embedded json eval failed, path: {}, reason: {}", path, e.getMessage());
            }
        }
    }

    public static void evalXmlEmbeddedExpressions(Node node, ScenarioContext context) {
        NamedNodeMap attribs;
        if (node.getNodeType() == 9) {
            node = node.getFirstChild();
        }
        int attribCount = (attribs = node.getAttributes()) == null ? 0 : attribs.getLength();
        HashSet<Attr> attributesToRemove = new HashSet<Attr>(attribCount);
        for (int i = 0; i < attribCount; ++i) {
            Attr attrib = (Attr)attribs.item(i);
            String value = attrib.getValue();
            if (!Script.isEmbeddedExpression(value = StringUtils.trimToEmpty(value))) continue;
            boolean optional = Script.isOptionalMacro(value);
            try {
                ScriptValue sv = Script.evalJsExpression(value.substring(optional ? 2 : 1), context);
                if (optional && sv.isNull()) {
                    attributesToRemove.add(attrib);
                    continue;
                }
                attrib.setValue(sv.getAsString());
                continue;
            }
            catch (Exception e) {
                context.logger.trace("embedded xml-attribute eval failed, path: {}, reason: {}", attrib.getName(), e.getMessage());
            }
        }
        for (Attr toRemove : attributesToRemove) {
            attribs.removeNamedItem(toRemove.getName());
        }
        NodeList nodeList = node.getChildNodes();
        int childCount = nodeList.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(childCount);
        for (int i = 0; i < childCount; ++i) {
            nodes.add(nodeList.item(i));
        }
        HashSet<Node> elementsToRemove = new HashSet<Node>(childCount);
        for (Node child : nodes) {
            String value = child.getNodeValue();
            if (value != null) {
                if (!Script.isEmbeddedExpression(value = StringUtils.trimToEmpty(value))) continue;
                boolean optional = Script.isOptionalMacro(value);
                try {
                    ScriptValue sv = Script.evalJsExpression(value.substring(optional ? 2 : 1), context);
                    if (optional && sv.isNull()) {
                        elementsToRemove.add(child);
                        continue;
                    }
                    if (sv.isMapLike()) {
                        Node evalNode = sv.getType() == ScriptValue.Type.XML ? sv.getValue(Node.class) : XmlUtils.fromMap(sv.getAsMap());
                        if (evalNode.getNodeType() == 9) {
                            evalNode = evalNode.getFirstChild();
                        }
                        if (child.getNodeType() == 4) {
                            child.setNodeValue(XmlUtils.toString(evalNode));
                            continue;
                        }
                        evalNode = node.getOwnerDocument().importNode(evalNode, true);
                        child.getParentNode().replaceChild(evalNode, child);
                        continue;
                    }
                    child.setNodeValue(sv.getAsString());
                }
                catch (Exception e) {
                    context.logger.trace("embedded xml-text eval failed, path: {}, reason: {}", child.getNodeName(), e.getMessage());
                }
                continue;
            }
            if (!child.hasChildNodes() && !child.hasAttributes()) continue;
            Script.evalXmlEmbeddedExpressions(child, context);
        }
        for (Node toRemove : elementsToRemove) {
            Node parent = toRemove.getParentNode();
            Node grandParent = parent.getParentNode();
            grandParent.removeChild(parent);
        }
    }

    public static ScriptValue copy(String name, String exp, ScenarioContext context, boolean validateName) {
        return Script.assign(AssignType.COPY, name, exp, context, validateName);
    }

    public static ScriptValue assign(String name, String exp, ScenarioContext context) {
        return Script.assign(AssignType.AUTO, name, exp, context, true);
    }

    private static void validateVariableName(String name) {
        if (!Script.isValidVariableName(name)) {
            throw new RuntimeException("invalid variable name: " + name);
        }
        if ("karate".equals(name)) {
            throw new RuntimeException("'karate' is a reserved name");
        }
        if ("request".equals(name) || "url".equals(name)) {
            throw new RuntimeException("'" + name + "' is a reserved name, also use the form '* " + name + " <expression>' instead");
        }
    }

    public static ScriptValue assign(AssignType assignType, String name, String exp, ScenarioContext context, boolean validateName) {
        ScriptValue sv;
        name = StringUtils.trimToEmpty(name);
        if (validateName) {
            Script.validateVariableName(name);
            if (context.bindings.adds.containsKey(name)) {
                context.logger.warn("over-writing built-in variable named: {} - with new value: {}", name, exp);
            }
        }
        switch (assignType) {
            case TEXT: {
                sv = new ScriptValue(exp);
                break;
            }
            case YAML: {
                ScriptValue yamlString = Script.evalKarateExpression(exp, context);
                DocumentContext yamlDoc = JsonUtils.fromYaml(yamlString.getAsString());
                Script.evalJsonEmbeddedExpressions(yamlDoc, context);
                sv = new ScriptValue(yamlDoc);
                break;
            }
            case CSV: {
                ScriptValue csvString = Script.evalKarateExpression(exp, context);
                DocumentContext csvDoc = JsonUtils.fromCsv(csvString.getAsString());
                sv = new ScriptValue(csvDoc);
                break;
            }
            case STRING: {
                ScriptValue str = Script.evalKarateExpression(exp, context);
                sv = new ScriptValue(str.getAsString());
                break;
            }
            case JSON: {
                DocumentContext jsonDoc = Script.toJsonDoc(Script.evalKarateExpression(exp, context), context);
                sv = new ScriptValue(jsonDoc);
                break;
            }
            case XML: {
                Node xmlDoc = Script.toXmlDoc(Script.evalKarateExpression(exp, context), context);
                sv = new ScriptValue(xmlDoc);
                break;
            }
            case XML_STRING: {
                Node xmlStringDoc = Script.toXmlDoc(Script.evalKarateExpression(exp, context), context);
                sv = new ScriptValue(XmlUtils.toString(xmlStringDoc));
                break;
            }
            case BYTE_ARRAY: {
                ScriptValue tempBytes = Script.evalKarateExpression(exp, context);
                sv = new ScriptValue(tempBytes.getAsByteArray());
                break;
            }
            case COPY: {
                sv = Script.evalKarateExpression(exp, context).copy(true);
                break;
            }
            default: {
                sv = Script.evalKarateExpression(exp, context);
            }
        }
        context.vars.put(name, sv);
        return sv;
    }

    public static DocumentContext toJsonDoc(ScriptValue sv, ScenarioContext context) {
        if (sv.isJson()) {
            return (DocumentContext)sv.getValue();
        }
        if (sv.isListLike()) {
            return JsonPath.parse((Object)sv.getAsList());
        }
        if (sv.isMapLike()) {
            return JsonPath.parse(sv.getAsMap());
        }
        if (sv.isUnknown()) {
            return JsonUtils.toJsonDoc(sv.getValue());
        }
        ScriptValue temp = Script.evalKarateExpression(sv.getAsString(), context);
        if (!temp.isJson()) {
            throw new RuntimeException("cannot convert, not a json string: " + sv);
        }
        return temp.getValue(DocumentContext.class);
    }

    private static Node toXmlDoc(ScriptValue sv, ScenarioContext context) {
        if (sv.isXml()) {
            return sv.getValue(Node.class);
        }
        if (sv.isMapLike()) {
            return XmlUtils.fromMap(sv.getAsMap());
        }
        if (sv.isUnknown()) {
            return XmlUtils.toXmlDoc(sv.getValue());
        }
        if (sv.isStringOrStream()) {
            ScriptValue temp = Script.evalKarateExpression(sv.getAsString(), context);
            if (!temp.isXml()) {
                throw new RuntimeException("cannot convert, not an xml string: " + sv);
            }
            return temp.getValue(Document.class);
        }
        throw new RuntimeException("cannot convert to xml: " + sv);
    }

    public static AssertionResult matchNamed(MatchType matchType, String expression, String path, String expected, ScenarioContext context) {
        ScriptValue actual;
        String name = StringUtils.trimToEmpty(expression);
        if (Script.isJsonPath(name) || Script.isXmlPath(name)) {
            path = name;
            name = "response";
        }
        if (name.startsWith(VAR_ROOT)) {
            name = name.substring(1);
        }
        if ((path = StringUtils.trimToNull(path)) == null) {
            int pos = name.lastIndexOf(41);
            if (name.startsWith("driver.") || pos != -1 && (pos == name.length() - 1 || name.charAt(pos + 1) == '.')) {
                ScriptValue actual2 = Script.evalKarateExpression(expression, context);
                return Script.matchScriptValue(matchType, actual2, VAR_ROOT, expected, context);
            }
            StringUtils.Pair pair = Script.parseVariableAndPath(name);
            name = pair.left;
            path = pair.right;
        }
        if ((actual = (ScriptValue)context.vars.get(name)) == null) {
            if (VAR_HEADER.equals(name)) {
                return Script.matchNamed(matchType, "responseHeaders", "$['" + path + "'][0]", expected, context);
            }
            actual = Script.evalKarateExpression(expression, context);
            if (actual.isJsonLike()) {
                path = VAR_ROOT;
            }
        }
        return Script.matchScriptValue(matchType, actual, path, expected, context);
    }

    public static AssertionResult matchScriptValue(MatchType matchType, ScriptValue actual, String path, String expected, ScenarioContext context) {
        switch (actual.getType()) {
            case STRING: 
            case INPUT_STREAM: {
                if (path.length() > 1) {
                    return Script.matchFailed(matchType, path, actual.getValue(), expected, "actual value is not JSON-like");
                }
                return Script.matchString(matchType, actual, expected, path, context);
            }
            case XML: {
                if (!VAR_ROOT.equals(path)) break;
                path = "/";
            }
        }
        if (Script.isDollarPrefixed(path)) {
            return Script.matchJsonOrObject(matchType, actual, path, expected, context);
        }
        if (actual.getType() != ScriptValue.Type.XML) {
            Document node = XmlUtils.fromMap(actual.getAsMap());
            actual = new ScriptValue(node);
        }
        return Script.matchXml(matchType, actual, path, expected, context);
    }

    public static AssertionResult matchString(MatchType matchType, ScriptValue actual, String expected, String path, ScenarioContext context) {
        ScriptValue expectedValue = Script.evalKarateExpression(expected, context);
        expected = expectedValue.getAsString();
        return Script.matchStringOrPattern('*', path, matchType, null, null, actual, expected, context);
    }

    public static boolean isMacro(String text) {
        return text.startsWith("#");
    }

    public static boolean isOptionalMacro(String text) {
        return text.startsWith("##");
    }

    private static String stripParentheses(String s) {
        return StringUtils.trimToEmpty(s.substring(1, s.length() - 1));
    }

    public static AssertionResult matchStringOrPattern(char delimiter, String path, MatchType stringMatchType, Object actRoot, Object actParent, ScriptValue actValue, String expected, ScenarioContext context) {
        block67: {
            block69: {
                block68: {
                    String macroExpression;
                    block66: {
                        if (expected != null) break block66;
                        if (!actValue.isNull()) {
                            if (stringMatchType == MatchType.NOT_EQUALS) {
                                return AssertionResult.PASS;
                            }
                            return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, "actual value is not null");
                        }
                        break block67;
                    }
                    if (!Script.isMacro(expected)) break block68;
                    if (Script.isOptionalMacro(expected)) {
                        macroExpression = expected.substring(2);
                        if (actValue.isNull()) {
                            boolean isEqual = macroExpression.equals("null") ? true : !macroExpression.equals("notnull");
                            if (isEqual) {
                                if (stringMatchType == MatchType.NOT_EQUALS) {
                                    return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, "actual value is null");
                                }
                                return AssertionResult.PASS;
                            }
                            if (stringMatchType == MatchType.NOT_EQUALS) {
                                return AssertionResult.PASS;
                            }
                            return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, "actual value is null");
                        }
                    } else {
                        macroExpression = expected.substring(1);
                    }
                    if (Script.isWithinParentheses(macroExpression)) {
                        MatchType matchType = stringMatchType;
                        macroExpression = Script.stripParentheses(macroExpression);
                        boolean isContains = true;
                        if (Script.isContainsMacro(macroExpression)) {
                            if (Script.isContainsOnlyMacro(macroExpression)) {
                                matchType = MatchType.CONTAINS_ONLY;
                                macroExpression = macroExpression.substring(2);
                            } else if (Script.isContainsAnyMacro(macroExpression)) {
                                matchType = MatchType.CONTAINS_ANY;
                                macroExpression = macroExpression.substring(2);
                            } else {
                                matchType = MatchType.CONTAINS;
                                macroExpression = macroExpression.substring(1);
                            }
                        } else if (Script.isNotContainsMacro(macroExpression)) {
                            matchType = MatchType.NOT_CONTAINS;
                            macroExpression = macroExpression.substring(2);
                        } else {
                            isContains = false;
                        }
                        ScriptValue expValue = Script.evalJsExpression(macroExpression, context, actValue, actRoot, actParent);
                        if (isContains && actValue.isListLike() && !expValue.isListLike()) {
                            expValue = new ScriptValue(Collections.singletonList(expValue.getValue()));
                        }
                        AssertionResult ar = Script.matchNestedObject(delimiter, path, matchType, actRoot, actParent, actValue.getValue(), expValue.getValue(), context);
                        if (!ar.pass && stringMatchType == MatchType.NOT_EQUALS) {
                            return AssertionResult.PASS;
                        }
                        return ar;
                    }
                    if (macroExpression.startsWith("regex")) {
                        String regex = macroExpression.substring(5).trim();
                        RegexValidator v = new RegexValidator(regex);
                        ValidationResult vr = v.validate(actValue);
                        if (!vr.isPass()) {
                            if (stringMatchType == MatchType.NOT_EQUALS) {
                                return AssertionResult.PASS;
                            }
                            return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, vr.getMessage());
                        }
                    } else if (macroExpression.startsWith("[") && macroExpression.indexOf(93) > 0) {
                        ValidationResult vr = ArrayValidator.INSTANCE.validate(actValue);
                        if (!vr.isPass()) {
                            if (stringMatchType == MatchType.NOT_EQUALS) {
                                return AssertionResult.PASS;
                            }
                            return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, vr.getMessage());
                        }
                        int endBracketPos = macroExpression.indexOf(93);
                        List actValueList = actValue.getAsList();
                        if (endBracketPos > 1) {
                            int arrayLength = actValueList.size();
                            String bracketContents = macroExpression.substring(1, endBracketPos);
                            String expression = bracketContents.indexOf(95) != -1 ? bracketContents : bracketContents + " == " + arrayLength;
                            ScriptValue result = Script.evalJsExpression(expression, context, new ScriptValue(arrayLength), actRoot, actParent);
                            if (!result.isBooleanTrue()) {
                                if (stringMatchType == MatchType.NOT_EQUALS) {
                                    return AssertionResult.PASS;
                                }
                                return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, "actual array length was: " + arrayLength);
                            }
                        }
                        if (macroExpression.length() > endBracketPos + 1) {
                            MatchType matchType;
                            String expression = macroExpression.substring(endBracketPos + 1);
                            expression = StringUtils.trimToNull(expression);
                            MatchType matchType2 = matchType = stringMatchType == MatchType.NOT_EQUALS ? MatchType.EACH_NOT_EQUALS : MatchType.EACH_EQUALS;
                            if (expression != null) {
                                if (expression.startsWith("?")) {
                                    expression = "'#" + expression + "'";
                                } else if (expression.startsWith("#")) {
                                    if (expression.startsWith("#regex")) {
                                        expression = expression.replaceAll("\\\\", "\\\\\\\\");
                                    }
                                    expression = "'" + expression + "'";
                                } else {
                                    if (Script.isWithinParentheses(expression)) {
                                        expression = Script.stripParentheses(expression);
                                    }
                                    if (Script.isContainsMacro(expression)) {
                                        if (Script.isContainsOnlyMacro(expression)) {
                                            matchType = MatchType.EACH_CONTAINS_ONLY;
                                            expression = expression.substring(2);
                                        } else if (Script.isContainsAnyMacro(expression)) {
                                            matchType = MatchType.EACH_CONTAINS_ANY;
                                            expression = expression.substring(2);
                                        } else {
                                            matchType = MatchType.EACH_CONTAINS;
                                            expression = expression.substring(1);
                                        }
                                    } else if (Script.isNotContainsMacro(expression)) {
                                        matchType = MatchType.EACH_NOT_CONTAINS;
                                        expression = expression.substring(2);
                                    }
                                }
                                return Script.matchJsonOrObject(matchType, new ScriptValue(actRoot), path, expression, context);
                            }
                        }
                    } else {
                        ScriptValue result;
                        int questionPos = macroExpression.indexOf(63);
                        String validatorName = null;
                        validatorName = questionPos != -1 ? macroExpression.substring(0, questionPos) : macroExpression;
                        if ((validatorName = StringUtils.trimToNull(validatorName)) != null) {
                            Validator v = VALIDATORS.get(validatorName);
                            if (v == null) {
                                boolean pass = expected.equals(actValue.getAsString());
                                if (!pass) {
                                    if (stringMatchType == MatchType.NOT_EQUALS) {
                                        return AssertionResult.PASS;
                                    }
                                    return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, "not equal");
                                }
                            } else {
                                ValidationResult vr = v.validate(actValue);
                                if (!vr.isPass()) {
                                    if (stringMatchType == MatchType.NOT_EQUALS) {
                                        return AssertionResult.PASS;
                                    }
                                    return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, vr.getMessage());
                                }
                            }
                        }
                        if (questionPos != -1 && !(result = Script.evalJsExpression(macroExpression = macroExpression.substring(questionPos + 1), context, actValue, actRoot, actParent)).isBooleanTrue()) {
                            if (stringMatchType == MatchType.NOT_EQUALS) {
                                return AssertionResult.PASS;
                            }
                            return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, "did not evaluate to 'true'");
                        }
                    }
                    break block67;
                }
                if (!actValue.isStringOrStream()) break block69;
                String actual = actValue.getAsString();
                switch (stringMatchType) {
                    case CONTAINS: {
                        if (!actual.contains(expected)) {
                            return Script.matchFailed(stringMatchType, path, actual, expected, "not a sub-string");
                        }
                        break block67;
                    }
                    case NOT_CONTAINS: {
                        if (actual.contains(expected)) {
                            return Script.matchFailed(stringMatchType, path, actual, expected, "does contain expected");
                        }
                        break block67;
                    }
                    case NOT_EQUALS: {
                        if (expected.equals(actual)) {
                            return Script.matchFailed(stringMatchType, path, actual, expected, "is equal");
                        }
                        return AssertionResult.PASS;
                    }
                    case EQUALS: {
                        if (!expected.equals(actual)) {
                            return Script.matchFailed(stringMatchType, path, actual, expected, "not equal");
                        }
                        break block67;
                    }
                    default: {
                        throw new RuntimeException("unsupported match type for string: " + (Object)((Object)stringMatchType));
                    }
                }
            }
            if (stringMatchType == MatchType.NOT_EQUALS) {
                return AssertionResult.PASS;
            }
            Object actual = actValue.getValue();
            return Script.matchFailed(stringMatchType, path, actual, expected, "actual value is not a string");
        }
        if (stringMatchType == MatchType.NOT_EQUALS) {
            return Script.matchFailed(stringMatchType, path, actValue.getValue(), expected, "matched");
        }
        return AssertionResult.PASS;
    }

    public static AssertionResult matchXml(MatchType matchType, ScriptValue actual, String path, String expression, ScenarioContext context) {
        Object actObject;
        Object expObject;
        Node node = actual.getValue(Node.class);
        actual = Script.evalXmlPathOnXmlNode(node, path);
        ScriptValue expected = Script.evalKarateExpression(expression, context);
        if (actual == null) {
            if (expected.isString() && "#notpresent".equals(expected.getValue())) {
                return AssertionResult.PASS;
            }
            return Script.matchFailed(matchType, path, null, expected.getValue(), "actual xpath does not exist");
        }
        switch (expected.getType()) {
            case XML: {
                Node expNode = expected.getValue(Node.class);
                expObject = XmlUtils.toObject(expNode, true);
                actObject = XmlUtils.toObject(actual.getValue(Node.class), true);
                break;
            }
            case MAP: {
                expObject = expected.getValue(Map.class);
                actObject = XmlUtils.toObject(actual.getValue(Node.class));
                break;
            }
            case JSON: {
                expObject = expected.getValue(DocumentContext.class).read(VAR_ROOT, new Predicate[0]);
                actObject = actual.getValue(List.class);
                break;
            }
            case LIST: {
                expObject = expected.getValue(List.class);
                actObject = actual.getValue(List.class);
                break;
            }
            default: {
                expObject = expected.getAsString();
                if ("#present".equals(expObject)) {
                    return AssertionResult.PASS;
                }
                if ("#notpresent".equals(expObject)) {
                    return Script.matchFailed(matchType, path, actual, expObject, "actual xpath exists");
                }
                actObject = actual.getAsString();
            }
        }
        if ("/".equals(path)) {
            path = "";
        }
        return Script.matchNestedObject('/', path, matchType, node, node.getParentNode(), actObject, expObject, context);
    }

    private static MatchType getInnerMatchType(MatchType outerMatchType) {
        switch (outerMatchType) {
            case EACH_CONTAINS: {
                return MatchType.CONTAINS;
            }
            case EACH_NOT_CONTAINS: {
                return MatchType.NOT_CONTAINS;
            }
            case EACH_CONTAINS_ONLY: {
                return MatchType.CONTAINS_ONLY;
            }
            case EACH_CONTAINS_ANY: {
                return MatchType.CONTAINS_ANY;
            }
            case EACH_EQUALS: {
                return MatchType.EQUALS;
            }
            case EACH_NOT_EQUALS: {
                return MatchType.EQUALS;
            }
        }
        throw new RuntimeException("unexpected outer match type: " + (Object)((Object)outerMatchType));
    }

    public static AssertionResult matchJsonOrObject(MatchType matchType, ScriptValue actual, String path, String expression, ScenarioContext context) {
        List<Object> expObject;
        Object actObject;
        DocumentContext actualDoc;
        switch (actual.getType()) {
            case MAP: 
            case JSON: 
            case LIST: {
                actualDoc = actual.getAsJsonDocument();
                break;
            }
            case XML: {
                actualDoc = XmlUtils.toJsonDoc(actual.getValue(Node.class));
                break;
            }
            case STRING: 
            case INPUT_STREAM: {
                String actualString = actual.getAsString();
                ScriptValue expectedString = Script.evalKarateExpression(expression, context);
                if (!expectedString.isStringOrStream()) {
                    return Script.matchFailed(matchType, path, actualString, expectedString.getValue(), "type of actual value is 'string' but that of expected is " + (Object)((Object)expectedString.getType()));
                }
                return Script.matchStringOrPattern('.', path, matchType, null, null, actual, expectedString.getAsString(), context);
            }
            case PRIMITIVE: {
                ScriptValue expected = Script.evalKarateExpression(expression, context);
                if (expected.isStringOrStream()) {
                    return Script.matchStringOrPattern('.', path, matchType, null, null, actual, expected.getAsString(), context);
                }
                return Script.matchPrimitive(matchType, path, actual.getValue(), expected.getValue());
            }
            case NULL: {
                ScriptValue expectedNull = Script.evalKarateExpression(expression, context);
                if (expectedNull.isNull()) {
                    if (matchType == MatchType.NOT_EQUALS) {
                        return Script.matchFailed(matchType, path, null, null, "actual and expected values are both null");
                    }
                    return AssertionResult.PASS;
                }
                if (!expectedNull.isStringOrStream()) {
                    if (matchType == MatchType.NOT_EQUALS) {
                        return AssertionResult.PASS;
                    }
                    return Script.matchFailed(matchType, path, null, expectedNull.getValue(), "actual value is null but expected is " + expectedNull);
                }
                return Script.matchStringOrPattern('.', path, matchType, null, null, actual, expectedNull.getAsString(), context);
            }
            case BYTE_ARRAY: {
                ScriptValue expectedBytesValue = Script.evalKarateExpression(expression, context);
                byte[] expectedBytes = expectedBytesValue.getAsByteArray();
                byte[] actualBytes = actual.getAsByteArray();
                if (Arrays.equals(expectedBytes, actualBytes)) {
                    if (matchType == MatchType.NOT_EQUALS) {
                        return Script.matchFailed(matchType, path, actualBytes, expectedBytes, "actual and expected byte-arrays are not equal");
                    }
                    return AssertionResult.PASS;
                }
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
                return Script.matchFailed(matchType, path, actualBytes, expectedBytes, "actual and expected byte-arrays are not equal");
            }
            default: {
                throw new RuntimeException("not json, cannot do json path for value: " + actual + ", path: " + path);
            }
        }
        ScriptValue expected = Script.evalKarateExpressionForMatch(expression, context);
        try {
            actObject = actualDoc.read(path, new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            String expString;
            if (expected.isString() && (Script.isOptionalMacro(expString = expected.getAsString()) || "#notpresent".equals(expString) || "#ignore".equals(expString))) {
                return AssertionResult.PASS;
            }
            return Script.matchFailed(matchType, path, null, expected.getValue(), "actual json-path does not exist");
        }
        switch (expected.getType()) {
            case JSON: {
                expObject = expected.getValue(DocumentContext.class).read(VAR_ROOT, new Predicate[0]);
                break;
            }
            default: {
                expObject = expected.getValue();
            }
        }
        switch (matchType) {
            case CONTAINS: 
            case NOT_CONTAINS: 
            case CONTAINS_ONLY: 
            case CONTAINS_ANY: 
            case CONTAINS_DEEP: {
                if (actObject instanceof List && !(expObject instanceof List)) {
                    expObject = Collections.singletonList(expObject);
                }
            }
            case NOT_EQUALS: 
            case EQUALS: {
                return Script.matchNestedObject('.', path, matchType, actualDoc, null, actObject, expObject, context);
            }
            case EACH_CONTAINS: 
            case EACH_NOT_CONTAINS: 
            case EACH_CONTAINS_ONLY: 
            case EACH_CONTAINS_ANY: 
            case EACH_EQUALS: 
            case EACH_NOT_EQUALS: {
                if (actObject instanceof List) {
                    List actList = (List)actObject;
                    MatchType listMatchType = Script.getInnerMatchType(matchType);
                    int actSize = actList.size();
                    for (int i = 0; i < actSize; ++i) {
                        Object actListObject = actList.get(i);
                        AssertionResult ar = Script.matchNestedObject('.', "$[" + i + "]", listMatchType, actObject, actListObject, actListObject, expObject, context);
                        if (ar.pass) continue;
                        if (matchType == MatchType.EACH_NOT_EQUALS) {
                            return AssertionResult.PASS;
                        }
                        return ar;
                    }
                    if (matchType == MatchType.EACH_NOT_EQUALS) {
                        return Script.matchFailed(matchType, path, actual.getValue(), expected.getValue(), "all list items matched");
                    }
                    return AssertionResult.PASS;
                }
                throw new RuntimeException("'match each' failed, not a json array: + " + actual + ", path: " + path);
            }
        }
        throw new RuntimeException("unexpected match type: " + (Object)((Object)matchType));
    }

    private static String getLeafNameFromXmlPath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos == -1) {
            return path;
        }
        if ((pos = (path = path.substring(pos + 1)).indexOf(91)) != -1) {
            return path.substring(0, pos);
        }
        return path;
    }

    private static Object toXmlString(String elementName, Object o) {
        if (o instanceof Map) {
            Document node = XmlUtils.fromObject(elementName, o);
            return XmlUtils.toString(node);
        }
        if (o instanceof Node) {
            return XmlUtils.toString((Node)o);
        }
        return o;
    }

    private static Object quoteIfString(Object o) {
        if (o instanceof String) {
            return "'" + o + "'";
        }
        return o;
    }

    private static boolean isNegation(MatchType type) {
        switch (type) {
            case NOT_CONTAINS: 
            case NOT_EQUALS: 
            case EACH_NOT_CONTAINS: 
            case EACH_NOT_EQUALS: {
                return true;
            }
        }
        return false;
    }

    public static AssertionResult matchFailed(MatchType matchType, String path, Object actObject, Object expObject, String reason) {
        if (path.startsWith("/")) {
            String leafName = Script.getLeafNameFromXmlPath(path);
            if (!"@".equals(leafName)) {
                actObject = Script.toXmlString(leafName, actObject);
                expObject = Script.toXmlString(leafName, expObject);
            }
            path = path.replace("/@/", "/@");
        }
        String message = String.format("path: %s, actual: %s, %sexpected: %s, reason: %s", path, Script.quoteIfString(actObject), Script.isNegation(matchType) ? "NOT " : "", Script.quoteIfString(expObject), reason);
        return AssertionResult.fail(message);
    }

    public static AssertionResult matchNestedObject(char delimiter, String path, MatchType matchType, Object actRoot, Object actParent, Object actObject, Object expObject, ScenarioContext context) {
        if (expObject instanceof Node) {
            expObject = XmlUtils.toObject((Node)expObject);
        }
        if (expObject == null) {
            if (actObject != null) {
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
                return Script.matchFailed(matchType, path, actObject, expObject, "actual value is not null");
            }
            if (matchType == MatchType.NOT_EQUALS) {
                return Script.matchFailed(matchType, path, actObject, expObject, "equal, both are null");
            }
            return AssertionResult.PASS;
        }
        if (expObject instanceof String) {
            ScriptValue actValue = new ScriptValue(actObject);
            return Script.matchStringOrPattern(delimiter, path, matchType, actRoot, actParent, actValue, expObject.toString(), context);
        }
        if (actObject == null) {
            if (matchType == MatchType.NOT_EQUALS) {
                return AssertionResult.PASS;
            }
            return Script.matchFailed(matchType, path, actObject, expObject, "actual value is null");
        }
        if (expObject instanceof Map) {
            if (!(actObject instanceof Map)) {
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
                return Script.matchFailed(matchType, path, actObject, expObject, "actual value is not map-like");
            }
            Map expMap = (Map)expObject;
            Map actMap = (Map)actObject;
            if (actMap.size() > expMap.size()) {
                if (matchType == MatchType.EQUALS || matchType == MatchType.CONTAINS_ONLY) {
                    int sizeDiff = actMap.size() - expMap.size();
                    LinkedHashMap diffMap = new LinkedHashMap(actMap);
                    for (String key : expMap.keySet()) {
                        diffMap.remove(key);
                    }
                    return Script.matchFailed(matchType, path, actObject, expObject, "actual value has " + sizeDiff + " more key(s) than expected: " + diffMap);
                }
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
            }
            LinkedHashSet unMatchedKeysAct = new LinkedHashSet(actMap.keySet());
            LinkedHashSet unMatchedKeysExp = new LinkedHashSet(expMap.keySet());
            AssertionResult firstMisMatch = null;
            for (Map.Entry expEntry : expMap.entrySet()) {
                String childPath;
                String key = (String)expEntry.getKey();
                Object childExp = expEntry.getValue();
                String string = childPath = delimiter == '.' ? JsonUtils.buildPath(path, key) : path + delimiter + key;
                if (!actMap.containsKey(key)) {
                    String childMacro;
                    boolean equal = false;
                    if (childExp instanceof String && (Script.isOptionalMacro(childMacro = (String)childExp) || childMacro.equals("#notpresent") || childMacro.equals("#ignore"))) {
                        if (matchType == MatchType.NOT_CONTAINS) {
                            return Script.matchFailed(matchType, childPath, "(not present)", childExp, "actual value contains expected");
                        }
                        equal = true;
                        unMatchedKeysExp.remove(key);
                    }
                    if (!equal) {
                        if (matchType == MatchType.NOT_EQUALS) {
                            return AssertionResult.PASS;
                        }
                        if (matchType != MatchType.NOT_CONTAINS) continue;
                        return AssertionResult.PASS;
                    }
                    if (matchType != MatchType.CONTAINS_ANY) continue;
                    return AssertionResult.PASS;
                }
                Object childAct = actMap.get(key);
                ScriptValue childActValue = new ScriptValue(childAct);
                MatchType childMatchType = MatchType.EQUALS;
                if (matchType.equals((Object)MatchType.CONTAINS_DEEP) && childActValue.isJsonLike()) {
                    childMatchType = MatchType.CONTAINS_DEEP;
                }
                AssertionResult ar = Script.matchNestedObject(delimiter, childPath, childMatchType, actRoot, actMap, childAct, childExp, context);
                if (ar.pass) {
                    ScriptValue childExpValue;
                    if (matchType == MatchType.CONTAINS_ANY) {
                        return AssertionResult.PASS;
                    }
                    if (matchType == MatchType.NOT_CONTAINS && (childExpValue = new ScriptValue(childExp)).isMapLike()) {
                        return AssertionResult.PASS;
                    }
                    unMatchedKeysExp.remove(key);
                    unMatchedKeysAct.remove(key);
                    continue;
                }
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
                if (matchType == MatchType.NOT_CONTAINS) {
                    return AssertionResult.PASS;
                }
                if (firstMisMatch != null) continue;
                firstMisMatch = ar;
            }
            if (matchType == MatchType.CONTAINS_ANY) {
                return Script.matchFailed(matchType, path, actObject, expObject, "no key-values matched");
            }
            if (!unMatchedKeysExp.isEmpty()) {
                if (matchType == MatchType.NOT_CONTAINS) {
                    return AssertionResult.PASS;
                }
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
                if (firstMisMatch != null) {
                    return firstMisMatch;
                }
                return Script.matchFailed(matchType, path, actObject, expObject, "all key-values did not match, expected has un-matched keys: " + unMatchedKeysExp);
            }
            if (!unMatchedKeysAct.isEmpty()) {
                if (matchType == MatchType.CONTAINS || matchType == MatchType.CONTAINS_DEEP || expMap.isEmpty()) {
                    return AssertionResult.PASS;
                }
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
                return Script.matchFailed(matchType, path, actObject, expObject, "all key-values did not match, actual has un-matched keys: " + unMatchedKeysAct);
            }
            if (matchType == MatchType.NOT_CONTAINS) {
                if (expMap.isEmpty()) {
                    return AssertionResult.PASS;
                }
                return Script.matchFailed(matchType, path, actObject, expObject, "actual contains all expected key-values");
            }
            if (matchType == MatchType.NOT_EQUALS) {
                return Script.matchFailed(matchType, path, actObject, expObject, "all key-values matched");
            }
            return AssertionResult.PASS;
        }
        if (expObject instanceof List) {
            int expCount;
            if (!(actObject instanceof List)) {
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
                return Script.matchFailed(matchType, path, actObject, expObject, "actual value is not list-like");
            }
            List expList = (List)expObject;
            List actList = (List)actObject;
            int actCount = actList.size();
            if (actCount != (expCount = expList.size())) {
                if (matchType == MatchType.EQUALS || matchType == MatchType.CONTAINS_ONLY) {
                    return Script.matchFailed(matchType, path, actObject, expObject, "actual and expected arrays are not the same size - " + actCount + ":" + expCount);
                }
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
            }
            if (matchType == MatchType.CONTAINS || matchType == MatchType.CONTAINS_ONLY || matchType == MatchType.CONTAINS_ANY || matchType == MatchType.NOT_CONTAINS || matchType == MatchType.CONTAINS_DEEP) {
                for (Object expListObject : expList) {
                    boolean found = false;
                    for (int i = 0; i < actCount; ++i) {
                        Object actListObject = actList.get(i);
                        String listPath = Script.buildListPath(delimiter, path, i);
                        MatchType childMatchType = matchType.equals((Object)MatchType.CONTAINS_DEEP) ? MatchType.CONTAINS_DEEP : MatchType.EQUALS;
                        AssertionResult ar = Script.matchNestedObject(delimiter, listPath, childMatchType, actRoot, actListObject, actListObject, expListObject, context);
                        if (!ar.pass) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        if (matchType == MatchType.NOT_CONTAINS) {
                            return Script.matchFailed(matchType, path + "[*]", actObject, expListObject, "actual value contains unexpected");
                        }
                        if (matchType != MatchType.CONTAINS_ANY) continue;
                        return AssertionResult.PASS;
                    }
                    if (matchType == MatchType.CONTAINS_ANY || matchType == MatchType.NOT_CONTAINS) continue;
                    return Script.matchFailed(matchType, path + "[*]", actObject, expListObject, "actual value does not contain expected");
                }
                if (matchType == MatchType.CONTAINS_ANY) {
                    return Script.matchFailed(matchType, path + "[*]", actObject, expList, "actual value does not contain any expected");
                }
                return AssertionResult.PASS;
            }
            for (int i = 0; i < expCount; ++i) {
                Object expListObject = expList.get(i);
                Object actListObject = actList.get(i);
                String listPath = Script.buildListPath(delimiter, path, i);
                AssertionResult ar = Script.matchNestedObject(delimiter, listPath, MatchType.EQUALS, actRoot, actListObject, actListObject, expListObject, context);
                if (ar.pass) continue;
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
                return Script.matchFailed(matchType, listPath, actListObject, expListObject, "[" + ar.message + "]");
            }
            if (matchType == MatchType.NOT_EQUALS) {
                return Script.matchFailed(matchType, path, actObject, expObject, "all list items matched");
            }
            return AssertionResult.PASS;
        }
        if (expObject instanceof BigDecimal) {
            BigDecimal expNumber = (BigDecimal)expObject;
            if (actObject instanceof BigDecimal) {
                BigDecimal actNumber = (BigDecimal)actObject;
                if (actNumber.compareTo(expNumber) != 0 && matchType != MatchType.NOT_EQUALS) {
                    return Script.matchFailed(matchType, path, actObject, expObject, "not equal (big decimal)");
                }
            } else {
                BigDecimal actNumber = Script.convertToBigDecimal(actObject);
                if ((actNumber == null || actNumber.compareTo(expNumber) != 0) && matchType != MatchType.NOT_EQUALS) {
                    return Script.matchFailed(matchType, path, actObject, expObject, "not equal (primitive : big decimal)");
                }
            }
            if (matchType == MatchType.NOT_EQUALS) {
                return Script.matchFailed(matchType, path, actObject, expObject, "equal");
            }
            return AssertionResult.PASS;
        }
        if (Script.isPrimitive(expObject.getClass())) {
            return Script.matchPrimitive(matchType, path, actObject, expObject);
        }
        throw new RuntimeException("unexpected type: " + expObject.getClass());
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.equals((Object)clazz);
    }

    private static String buildListPath(char delimiter, String path, int index) {
        int listIndex = delimiter == '/' ? index + 1 : index;
        return path + "[" + listIndex + "]";
    }

    private static BigDecimal convertToBigDecimal(Object o) {
        DecimalFormat df = new DecimalFormat();
        df.setParseBigDecimal(true);
        try {
            return (BigDecimal)df.parse(o.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static AssertionResult matchPrimitive(MatchType matchType, String path, Object actObject, Object expObject) {
        block14: {
            block15: {
                if (actObject == null) {
                    if (matchType == MatchType.NOT_EQUALS) {
                        return AssertionResult.PASS;
                    }
                    return Script.matchFailed(matchType, path, actObject, expObject, "actual value is null");
                }
                if (expObject == null) {
                    if (matchType == MatchType.NOT_EQUALS) {
                        return AssertionResult.PASS;
                    }
                    return Script.matchFailed(matchType, path, actObject, expObject, "expected value is null");
                }
                if (expObject.getClass().equals(actObject.getClass())) break block15;
                if (actObject instanceof BigDecimal) {
                    BigDecimal actNumber = (BigDecimal)actObject;
                    BigDecimal expNumber = Script.convertToBigDecimal(expObject);
                    if ((expNumber == null || expNumber.compareTo(actNumber) != 0) && matchType != MatchType.NOT_EQUALS) {
                        return Script.matchFailed(matchType, path, actObject, expObject, "not equal (big decimal : primitive)");
                    }
                    break block14;
                } else if (actObject instanceof Number && expObject instanceof Number) {
                    String exp = actObject + " == " + expObject;
                    ScriptValue sv = Script.evalJsExpression(exp, null);
                    if (!sv.isBooleanTrue() && matchType != MatchType.NOT_EQUALS) {
                        return Script.matchFailed(matchType, path, actObject, expObject, "not equal (" + actObject.getClass().getSimpleName() + " : " + expObject.getClass().getSimpleName() + ")");
                    }
                    break block14;
                } else {
                    if (matchType == MatchType.NOT_EQUALS) {
                        return AssertionResult.PASS;
                    }
                    return Script.matchFailed(matchType, path, actObject, expObject, "not equal (" + actObject.getClass().getSimpleName() + " : " + expObject.getClass().getSimpleName() + ")");
                }
            }
            if (!expObject.equals(actObject)) {
                if (matchType == MatchType.NOT_EQUALS) {
                    return AssertionResult.PASS;
                }
                return Script.matchFailed(matchType, path, actObject, expObject, "not equal (" + actObject.getClass().getSimpleName() + ")");
            }
        }
        if (matchType == MatchType.NOT_EQUALS) {
            return Script.matchFailed(matchType, path, actObject, expObject, "equal");
        }
        return AssertionResult.PASS;
    }

    public static void removeValueByPath(String name, String path, ScenarioContext context) {
        Script.setValueByPath(name, path, ScriptValue.NULL, true, context, false);
    }

    public static void setValueByPath(String name, String path, ScriptValue value, ScenarioContext context) {
        Script.setValueByPath(name, path, value, false, context, false);
    }

    public static void setValueByPath(String name, String path, String exp, ScenarioContext context) {
        Script.setValueByPath(name, path, exp, false, context, false);
    }

    public static void setValueByPath(String name, String path, String exp, boolean delete, ScenarioContext context, boolean viaTable) {
        ScriptValue value;
        ScriptValue scriptValue = value = delete ? ScriptValue.NULL : Script.evalKarateExpression(exp, context);
        if (viaTable && value.isNull() && !Script.isWithinParentheses(exp)) {
            return;
        }
        Script.setValueByPath(name, path, value, delete, context, viaTable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setValueByPath(String name, String path, ScriptValue value, boolean delete, ScenarioContext context, boolean viaTable) {
        ScriptValue target;
        name = StringUtils.trimToEmpty(name);
        if ((path = StringUtils.trimToNull(path)) == null) {
            StringUtils.Pair nameAndPath = Script.parseVariableAndPath(name);
            name = nameAndPath.left;
            path = nameAndPath.right;
        }
        Script.validateVariableName(name);
        if (Script.isJsonPath(path)) {
            target = (ScriptValue)context.vars.get(name);
            if (target == null || target.isNull()) {
                if (!viaTable) throw new RuntimeException("variable is null or not set '" + name + "'");
                DocumentContext empty = path.startsWith("$[") && !path.startsWith("$['") ? JsonUtils.emptyJsonArray(0) : JsonUtils.emptyJsonObject();
                target = new ScriptValue(empty);
                context.vars.put(name, target);
            }
            if (!target.isJsonLike()) throw new RuntimeException("cannot set json path on unexpected type: " + target);
            DocumentContext dc = target.getAsJsonDocument();
            JsonUtils.setValueByPath(dc, path, value.getAfterConvertingFromJsonOrXmlIfNeeded(), delete);
            return;
        } else {
            if (!Script.isXmlPath(path)) throw new RuntimeException("unexpected path: " + path);
            target = (ScriptValue)context.vars.get(name);
            if (target == null || target.isNull()) {
                if (!viaTable) throw new RuntimeException("variable is null or not set '" + name + "'");
                Document empty = XmlUtils.newDocument();
                target = new ScriptValue(empty);
                context.vars.put(name, target);
            }
            Document doc = target.getValue(Document.class);
            if (delete) {
                XmlUtils.removeByPath(doc, path);
                return;
            } else if (value.getType() == ScriptValue.Type.XML) {
                Node node = value.getValue(Node.class);
                XmlUtils.setByPath(doc, path, node);
                return;
            } else if (value.isMapLike()) {
                Document node = XmlUtils.fromMap(value.getAsMap());
                XmlUtils.setByPath(doc, path, node);
                return;
            } else {
                XmlUtils.setByPath((Node)doc, path, value.getAsString());
            }
        }
    }

    public static ScriptValue call(String name, String argString, ScenarioContext context, boolean reuseParentConfig) {
        ScriptValue argValue = Script.evalKarateExpression(argString, context);
        ScriptValue sv = Script.evalKarateExpression(name, context);
        switch (sv.getType()) {
            case JAVA_FUNCTION: {
                Function function = sv.getValue(Function.class);
                return Script.evalJavaFunctionCall(function, argValue.getValue(), context);
            }
            case JS_FUNCTION: {
                ScriptObjectMirror som = sv.getValue(ScriptObjectMirror.class);
                return Script.evalJsFunctionCall(som, argValue.getAfterConvertingFromJsonOrXmlIfNeeded(), context);
            }
            case FEATURE: {
                Object callArg = null;
                switch (argValue.getType()) {
                    case LIST: {
                        callArg = argValue.getValue(List.class);
                        break;
                    }
                    case JSON: {
                        callArg = argValue.getValue(DocumentContext.class).read(VAR_ROOT, new Predicate[0]);
                        break;
                    }
                    case MAP: {
                        callArg = argValue.getValue(Map.class);
                        break;
                    }
                    case NULL: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("only json/map or list/array allowed as feature call argument");
                    }
                }
                Feature feature = sv.getValue(Feature.class);
                return Script.evalFeatureCall(feature, callArg, context, reuseParentConfig);
            }
        }
        context.logger.warn("not a js function or feature file: {} - {}", name, sv);
        return ScriptValue.NULL;
    }

    public static ScriptValue evalJavaFunctionCall(Function function, Object callArg, ScenarioContext context) {
        try {
            Object result = function.apply(callArg);
            return new ScriptValue(result);
        }
        catch (Exception e) {
            String message = "java function call failed: " + e.getMessage();
            context.logger.error(message, new Object[0]);
            throw new KarateException(message);
        }
    }

    public static ScriptValue evalJsFunctionCall(ScriptObjectMirror som, Object callArg, ScenarioContext context) {
        try {
            Object result = callArg != null ? som.call((Object)som, new Object[]{callArg}) : som.call((Object)som, new Object[0]);
            return new ScriptValue(result);
        }
        catch (Exception e) {
            String message = "javascript function call failed: " + e.getMessage();
            context.logger.error(message, new Object[0]);
            context.logger.error("failed function body: " + som, new Object[0]);
            throw new KarateException(message);
        }
    }

    public static ScriptValue evalFeatureCall(Feature feature, Object callArg, ScenarioContext context, boolean reuseParentConfig) {
        if (callArg instanceof Collection) {
            Collection items = (Collection)callArg;
            Object[] array = items.toArray();
            ArrayList<Object> result = new ArrayList<Object>(array.length);
            ArrayList<String> errors = new ArrayList<String>(array.length);
            for (int i = 0; i < array.length; ++i) {
                Object rowArg = array[i];
                if (rowArg instanceof Map) {
                    Map rowArgMap = (Map)rowArg;
                    try {
                        CallContext callContext = CallContext.forCall(feature, context, rowArgMap, i, reuseParentConfig);
                        ScriptValue rowResult = Script.evalFeatureCall(callContext);
                        result.add(rowResult.getValue());
                    }
                    catch (KarateException ke) {
                        String argString = new ScriptValue(rowArg).getAsString();
                        String message = "feature call (loop) failed at index: " + i + "\ncaller: " + feature.getRelativePath() + "\narg: " + argString + "\n" + ke.getMessage();
                        errors.add(message);
                        context.logger.error("{}", message);
                    }
                    continue;
                }
                throw new RuntimeException("argument not json or map for feature call loop array position: " + i + ", " + rowArg);
            }
            if (!errors.isEmpty()) {
                String caller = context.featureContext.feature.getRelativePath();
                String message = "feature call (loop) failed: " + feature.getRelativePath() + "\ncaller: " + caller + "\nitems: " + items + "\nerrors:";
                for (String s : errors) {
                    message = message + "\n-------\n" + s;
                }
                throw new KarateException(message);
            }
            return new ScriptValue(result);
        }
        if (callArg == null || callArg instanceof Map) {
            Map argAsMap = (Map)callArg;
            try {
                CallContext callContext = CallContext.forCall(feature, context, argAsMap, -1, reuseParentConfig);
                return Script.evalFeatureCall(callContext);
            }
            catch (KarateException ke) {
                String argString = new ScriptValue(callArg).getAsString();
                String message = "feature call failed: " + feature.getRelativePath() + "\narg: " + argString + "\n" + ke.getMessage();
                context.logger.error("{}", message);
                throw new KarateException(message, ke);
            }
        }
        throw new RuntimeException("unexpected feature call arg type: " + callArg.getClass());
    }

    private static ScriptValue evalFeatureCall(CallContext callContext) {
        FeatureResult result = Engine.executeFeatureSync(null, callContext.feature, null, callContext);
        callContext.context.addCallResult(result);
        result.setCallArg(callContext.callArg);
        result.setLoopIndex(callContext.loopIndex);
        if (result.isFailed()) {
            throw result.getErrorsCombined();
        }
        return new ScriptValue(result.getResultAsPrimitiveMap());
    }

    public static StringUtils.Pair parseCallArgs(String line) {
        int pos = line.indexOf("read(");
        if (pos != -1) {
            pos = line.indexOf(41);
            if (pos == -1) {
                throw new RuntimeException("failed to parse call arguments: " + line);
            }
            return new StringUtils.Pair(line.substring(0, pos + 1), line.substring(pos + 1));
        }
        pos = line.indexOf(32);
        if (pos == -1) {
            return new StringUtils.Pair(line, null);
        }
        return new StringUtils.Pair(line.substring(0, pos), line.substring(pos));
    }

    public static void callAndUpdateConfigAndAlsoVarsIfMapReturned(boolean callOnce, String name, String arg, ScenarioContext context) {
        ScriptValue sv = callOnce ? Script.callWithCache(name, arg, context, true) : Script.call(name, arg, context, true);
        if (sv.isMapLike()) {
            sv.getAsMap().forEach((k, v) -> context.vars.put((String)k, v));
        } else {
            context.logger.trace("no vars returned from function call result: {}", sv);
        }
    }

    public static AssertionResult assertBoolean(String expression, ScenarioContext context) {
        ScriptValue result = Script.evalJsExpression(expression, context);
        if (!result.isBooleanTrue()) {
            return AssertionResult.fail("assert evaluated to false: " + expression);
        }
        return AssertionResult.PASS;
    }

    public static String replacePlaceholderText(String text, String token, String replaceWith, ScenarioContext context) {
        if (text == null) {
            return null;
        }
        if ((replaceWith = StringUtils.trimToNull(replaceWith)) == null) {
            return text;
        }
        try {
            ScriptValue sv = Script.evalKarateExpression(replaceWith, context);
            replaceWith = sv.getAsString();
        }
        catch (Exception e) {
            throw new RuntimeException("expression error (replace string values need to be within quotes): " + e.getMessage());
        }
        if (replaceWith == null) {
            return text;
        }
        if ((token = StringUtils.trimToNull(token)) == null) {
            return text;
        }
        char firstChar = token.charAt(0);
        if (Character.isLetterOrDigit(firstChar)) {
            token = '<' + token + '>';
        }
        return text.replace(token, replaceWith);
    }

    public static String replacePlaceholders(String text, List<Map<String, String>> list, ScenarioContext context) {
        if (text == null) {
            return null;
        }
        if (list == null) {
            return text;
        }
        for (Map<String, String> map : list) {
            String token = map.get(TOKEN);
            if (token == null) continue;
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            keys.remove(TOKEN);
            Iterator iterator = keys.iterator();
            if (!iterator.hasNext()) continue;
            String key = (String)keys.iterator().next();
            String value = map.get(key);
            text = Script.replacePlaceholderText(text, token, value, context);
        }
        return text;
    }

    public static List<Map<String, Object>> evalTable(List<Map<String, String>> list, ScenarioContext context) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(list.size());
        for (Map<String, String> map : list) {
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>(map);
            ArrayList toRemove = new ArrayList(map.size());
            for (Map.Entry entry : row.entrySet()) {
                String exp = (String)entry.getValue();
                ScriptValue sv = Script.evalKarateExpression(exp, context);
                if (sv.isNull() && !Script.isWithinParentheses(exp)) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                if (sv.isJsonLike()) {
                    entry.setValue(sv.getAsJsonDocument().read(VAR_ROOT, new Predicate[0]));
                    continue;
                }
                if (sv.isString()) {
                    entry.setValue(sv.getAsString());
                    continue;
                }
                entry.setValue(sv.getValue());
            }
            for (String string : toRemove) {
                row.remove(string);
            }
            result.add(row);
        }
        return result;
    }

    public static void setByPathTable(String name, String path, List<Map<String, String>> list, ScenarioContext context) {
        name = StringUtils.trimToEmpty(name);
        if ((path = StringUtils.trimToNull(path)) == null) {
            StringUtils.Pair nameAndPath = Script.parseVariableAndPath(name);
            name = nameAndPath.left;
            path = nameAndPath.right;
        }
        for (Map<String, String> map : list) {
            String append = map.get(PATH);
            if (append == null) continue;
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            keys.remove(PATH);
            int columnCount = keys.size();
            for (int i = 0; i < columnCount; ++i) {
                String finalPath;
                String suffix;
                String key = (String)keys.get(i);
                String expression = StringUtils.trimToNull(map.get(key));
                if (expression == null) continue;
                try {
                    int arrayIndex = Integer.valueOf(key);
                    suffix = "[" + arrayIndex + "]";
                }
                catch (NumberFormatException e) {
                    String string = suffix = columnCount > 1 ? "[" + i + "]" : "";
                }
                if (append.startsWith("/") || path != null && path.startsWith("/")) {
                    finalPath = path == null ? append + suffix : path + suffix + '/' + append;
                } else {
                    if (path == null) {
                        path = VAR_ROOT;
                    }
                    finalPath = path + suffix + '.' + append;
                }
                Script.setValueByPath(name, finalPath, expression, false, context, true);
            }
        }
    }

    static {
        VALIDATORS.put("ignore", IgnoreValidator.INSTANCE);
        VALIDATORS.put("null", NullValidator.INSTANCE);
        VALIDATORS.put("notnull", NotNullValidator.INSTANCE);
        VALIDATORS.put("present", IgnoreValidator.INSTANCE);
        VALIDATORS.put("uuid", UuidValidator.INSTANCE);
        VALIDATORS.put("string", StringValidator.INSTANCE);
        VALIDATORS.put("number", NumberValidator.INSTANCE);
        VALIDATORS.put("boolean", BooleanValidator.INSTANCE);
        VALIDATORS.put("array", ArrayValidator.INSTANCE);
        VALIDATORS.put("object", ObjectValidator.INSTANCE);
        VAR_AND_PATH_PATTERN = Pattern.compile("\\w+");
        VARIABLE_PATTERN = Pattern.compile(VARIABLE_PATTERN_STRING);
    }
}

