/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringUtils {
    private static final String EMPTY = "";
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("^function[^(]*\\(");

    private StringUtils() {
    }

    public static Pair pair(String left, String right) {
        return new Pair(left, right);
    }

    public static String truncate(String s, int length, boolean addDots) {
        if (s == null) {
            return EMPTY;
        }
        if (s.length() > length) {
            return addDots ? s.substring(0, length) + " ..." : s.substring(0, length);
        }
        return s;
    }

    public static String trimToEmpty(String s) {
        if (s == null) {
            return EMPTY;
        }
        return s.trim();
    }

    public static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        String temp = StringUtils.trimToEmpty(s);
        return EMPTY.equals(temp) ? null : temp;
    }

    public static String repeat(char c, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String join(Object[] a, char delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            sb.append(a[i]);
            if (i == a.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(Collection<String> c, char delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = c.iterator();
        while (iterator.hasNext()) {
            sb.append((Object)iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static List<String> split(String s, char delimiter) {
        String temp;
        int pos = s.indexOf(delimiter);
        if (pos == -1) {
            return Collections.singletonList(s);
        }
        ArrayList<String> list = new ArrayList<String>();
        int startPos = 0;
        int searchPos = 0;
        while (pos != -1) {
            if (pos > 0 && s.charAt(pos - 1) == '\\') {
                s = s.substring(0, pos - 1) + s.substring(pos);
                searchPos = pos;
            } else {
                temp = s.substring(startPos, pos);
                if (!EMPTY.equals(temp)) {
                    list.add(temp);
                }
                searchPos = startPos = pos + 1;
            }
            pos = s.indexOf(delimiter, searchPos);
        }
        if (startPos != s.length() && !EMPTY.equals(temp = s.substring(startPos))) {
            list.add(temp);
        }
        return list;
    }

    public static boolean isBlank(String s) {
        return StringUtils.trimToNull(s) == null;
    }

    public static String toIdString(String name) {
        return name.replaceAll("[\\s_]", "-").toLowerCase();
    }

    public static Pair splitByFirstLineFeed(String text) {
        String left = EMPTY;
        String right = EMPTY;
        if (text != null) {
            int pos = text.indexOf(10);
            if (pos != -1) {
                left = text.substring(0, pos).trim();
                right = text.substring(pos).trim();
            } else {
                left = text.trim();
            }
        }
        return StringUtils.pair(left, right);
    }

    public static List<String> toStringLines(String text) {
        return new BufferedReader(new StringReader(text)).lines().collect(Collectors.toList());
    }

    public static int countLineFeeds(String text) {
        int count = 0;
        for (char c : text.toCharArray()) {
            if (c != '\n') continue;
            ++count;
        }
        return count;
    }

    public static int wrappedLinesEstimate(String text, int colWidth) {
        List<String> lines = StringUtils.toStringLines(text);
        int estimate = 0;
        for (String s : lines) {
            int wrapEstimate = (int)Math.ceil(s.length() / colWidth);
            if (wrapEstimate == 0) {
                ++estimate;
                continue;
            }
            estimate += wrapEstimate;
        }
        return estimate;
    }

    public static boolean isJavaScriptFunction(String text) {
        return FUNCTION_PATTERN.matcher(text).find();
    }

    public static String fixJavaScriptFunction(String text) {
        Matcher matcher = FUNCTION_PATTERN.matcher(text);
        if (matcher.find()) {
            return matcher.replaceFirst("function(");
        }
        return text;
    }

    public static class Pair {
        public final String left;
        public final String right;

        public Pair(String left, String right) {
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object obj) {
            Pair o = (Pair)obj;
            return this.left.equals(o.left) && this.right.equals(o.right);
        }
    }
}

