/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.CallContext;
import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Match;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.StepActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.Step;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import java.util.List;
import java.util.Map;

public class FeatureBackend {
    private final Feature feature;
    private final StepActions actions;
    private boolean corsEnabled;
    private final ScenarioContext context;
    private final String featureName;
    private static final String VAR_AFTER_SCENARIO = "afterScenario";
    private static final String ALLOWED_METHODS = "GET, HEAD, POST, PUT, DELETE, PATCH";

    private static void putBinding(String name, ScenarioContext context) {
        String function = "function(a){ return karate." + name + "(a) }";
        context.vars.put(name, Script.evalJsExpression(function, context));
    }

    private static void putBinding2(String name, ScenarioContext context) {
        String function = "function(a, b){ return karate." + name + "(a, b) }";
        context.vars.put(name, Script.evalJsExpression(function, context));
    }

    public boolean isCorsEnabled() {
        return this.corsEnabled;
    }

    public ScenarioContext getContext() {
        return this.context;
    }

    public FeatureBackend(Feature feature) {
        this(feature, null);
    }

    public FeatureBackend(Feature feature, Map<String, Object> arg) {
        this.feature = feature;
        this.featureName = feature.getPath().toFile().getName();
        CallContext callContext = new CallContext(null, false, new ExecutionHook[0]);
        FeatureContext featureContext = new FeatureContext(null, feature, null);
        this.actions = new StepActions(featureContext, callContext, null, null);
        this.context = this.actions.context;
        FeatureBackend.putBinding("pathMatches", this.context);
        FeatureBackend.putBinding("methodIs", this.context);
        FeatureBackend.putBinding("paramValue", this.context);
        FeatureBackend.putBinding("typeContains", this.context);
        FeatureBackend.putBinding("acceptContains", this.context);
        FeatureBackend.putBinding2("headerContains", this.context);
        FeatureBackend.putBinding("bodyPath", this.context);
        if (arg != null) {
            arg.forEach((k, v) -> this.context.vars.put((String)k, v));
        }
        if (feature.isBackgroundPresent()) {
            for (Step step : feature.getBackground().getSteps()) {
                Result result = Engine.executeStep(step, this.actions);
                if (!result.isFailed()) continue;
                String message = "server-side background init failed - " + this.featureName + ":" + step.getLine();
                this.context.logger.error(message, new Object[0]);
                throw new KarateException(message, result.getError());
            }
        }
        this.corsEnabled = this.context.getConfig().isCorsEnabled();
        this.context.logger.info("backend initialized", new Object[0]);
    }

    public ScriptValueMap handle(ScriptValueMap args) {
        boolean matched = false;
        this.context.vars.putAll(args);
        block0: for (FeatureSection fs : this.feature.getSections()) {
            if (fs.isOutline()) {
                this.context.logger.warn("skipping scenario outline - {}:{}", this.featureName, fs.getScenarioOutline().getLine());
                break;
            }
            Scenario scenario = fs.getScenario();
            if (!this.isMatchingScenario(scenario)) continue;
            matched = true;
            for (Step step : scenario.getSteps()) {
                Result result = Engine.executeStep(step, this.actions);
                if (result.isAborted()) {
                    this.context.logger.debug("abort at {}:{}", this.featureName, step.getLine());
                    break block0;
                }
                if (!result.isFailed()) continue;
                String message = "server-side scenario failed - " + this.featureName + ":" + step.getLine();
                this.context.logger.error(message, new Object[0]);
                throw new KarateException(message, result.getError());
            }
        }
        if (!matched) {
            this.context.logger.warn("no scenarios matched", new Object[0]);
        }
        return this.context.vars;
    }

    private boolean isMatchingScenario(Scenario scenario) {
        String expression = StringUtils.trimToNull(scenario.getName() + scenario.getDescription());
        if (expression == null) {
            this.context.logger.debug("scenario matched: (empty)", new Object[0]);
            return true;
        }
        try {
            ScriptValue sv = Script.evalJsExpression(expression, this.context);
            if (sv.isBooleanTrue()) {
                this.context.logger.debug("scenario matched: {}", expression);
                return true;
            }
            this.context.logger.debug("scenario skipped: {}", expression);
            return false;
        }
        catch (Exception e) {
            this.context.logger.warn("scenario match evaluation failed: {}", e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse buildResponse(HttpRequest request, long startTime) {
        Map<String, Object> responseHeadersMap;
        Map<String, Object> configResponseHeadersMap;
        ScriptValue afterScenario;
        ScriptValue responseStatusValue;
        ScriptValue responseValue;
        if (this.corsEnabled && "OPTIONS".equals(request.getMethod())) {
            HttpResponse response = new HttpResponse(startTime, System.currentTimeMillis());
            response.setStatus(200);
            response.addHeader("Allow", ALLOWED_METHODS);
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.addHeader("Access-Control-Allow-Methods", ALLOWED_METHODS);
            List requestHeaders = (List)request.getHeaders().get("Access-Control-Request-Headers");
            if (requestHeaders != null) {
                response.putHeader("Access-Control-Allow-Headers", requestHeaders);
            }
            return response;
        }
        Match match = new Match().text("requestUrlBase", request.getUrlBase()).text("requestUri", request.getUri()).text("requestMethod", request.getMethod()).def("requestHeaders", request.getHeaders()).def("responseStatus", 200).def("requestParams", request.getParams());
        byte[] requestBytes = request.getBody();
        if (requestBytes != null) {
            match.def("requestBytes", requestBytes);
            String requestString = FileUtils.toString(requestBytes);
            Object requestBody = requestString;
            if (Script.isJson(requestString)) {
                try {
                    requestBody = JsonUtils.toJsonDoc(requestString);
                }
                catch (Exception e) {
                    this.context.logger.warn("json parsing failed, request data type set to string: {}", e.getMessage());
                }
            } else if (Script.isXml(requestString)) {
                try {
                    requestBody = XmlUtils.toXmlDoc(requestString);
                }
                catch (Exception e) {
                    this.context.logger.warn("xml parsing failed, request data type set to string: {}", e.getMessage());
                }
            }
            match.def("request", requestBody);
        }
        FeatureBackend featureBackend = this;
        synchronized (featureBackend) {
            ScriptValueMap result = this.handle(match.vars());
            ScriptValue configResponseHeaders = this.context.getConfig().getResponseHeaders();
            responseValue = (ScriptValue)result.remove("response");
            responseStatusValue = (ScriptValue)result.remove("responseStatus");
            ScriptValue responseHeaders = (ScriptValue)result.remove("responseHeaders");
            afterScenario = (ScriptValue)result.remove(VAR_AFTER_SCENARIO);
            if (afterScenario == null) {
                afterScenario = this.context.getConfig().getAfterScenario();
            }
            configResponseHeadersMap = configResponseHeaders == null ? null : configResponseHeaders.evalAsMap(this.context);
            responseHeadersMap = responseHeaders == null ? null : responseHeaders.evalAsMap(this.context);
        }
        int responseStatus = responseStatusValue == null ? 200 : Integer.valueOf(responseStatusValue.getAsString());
        HttpResponse response = new HttpResponse(startTime, System.currentTimeMillis());
        response.setStatus(responseStatus);
        if (responseValue != null && !responseValue.isNull()) {
            response.setBody(responseValue.getAsByteArray());
        }
        if (responseHeadersMap != null) {
            if (configResponseHeadersMap != null) {
                for (Map.Entry entry : configResponseHeadersMap.entrySet()) {
                    responseHeadersMap.putIfAbsent((String)entry.getKey(), entry.getValue());
                }
            }
        } else if (configResponseHeadersMap != null) {
            responseHeadersMap = configResponseHeadersMap;
        }
        boolean contentTypeHeaderExists = false;
        if (responseHeadersMap != null) {
            for (Map.Entry<String, Object> entry : responseHeadersMap.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                if ("Content-Type".equalsIgnoreCase(k)) {
                    contentTypeHeaderExists = true;
                }
                if (v instanceof List) {
                    response.putHeader(k, (List)v);
                    continue;
                }
                if (v == null) continue;
                response.addHeader(k, v.toString());
            }
        }
        if (!contentTypeHeaderExists && responseValue != null) {
            response.addHeader("Content-Type", HttpUtils.getContentType(responseValue));
        }
        if (this.corsEnabled) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        }
        if (afterScenario != null && afterScenario.isFunction()) {
            afterScenario.invokeFunction(this.context, null);
        }
        return response;
    }
}

