/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.HtmlReport;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.Tag;
import com.intuit.karate.core.Tags;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlFeatureReport
extends HtmlReport {
    private final FeatureResult featureResult;
    private int stepCounter;

    private void stepHtml(boolean calledFromBackground, String scenarioMeta, StepResult stepResult, Node parent, int depth) {
        List<FeatureResult> list;
        List<Embed> embeds;
        String refNum = ++this.stepCounter + "";
        Step step = stepResult.getStep();
        Result result = stepResult.getResult();
        String extraClass = result.isFailed() ? "failed" : (result.isSkipped() ? "skipped" : "passed");
        boolean isBackground = calledFromBackground || depth == 0 && step.isBackground();
        List<String> comments = step.getComments();
        if (comments != null) {
            for (String comment : comments) {
                Element commentContainer = this.div("step-container", new Node[0]);
                String refClass = isBackground ? "bg-step" : extraClass;
                commentContainer.appendChild(this.div("step-ref " + refClass, ""));
                for (int i = 0; i < depth; ++i) {
                    commentContainer.appendChild(this.div("step-indent", " "));
                }
                commentContainer.appendChild(this.div("step-cell comment", comment));
                Element commentRow = this.div("step-row", commentContainer, this.div("time-cell comment", new Node[0]));
                if (isBackground) {
                    commentRow.setAttribute("data-parent", scenarioMeta + "bg");
                }
                parent.appendChild(commentRow);
            }
        }
        Element stepContainer = this.div("step-container", new Node[0]);
        stepContainer.setAttribute("id", refNum);
        String refClass = isBackground ? "bg-step" : extraClass;
        stepContainer.appendChild(this.div("step-ref " + refClass, refNum));
        for (int i = 0; i < depth; ++i) {
            stepContainer.appendChild(this.div("step-indent", " "));
        }
        stepContainer.appendChild(this.div("step-cell " + extraClass, step.getPrefix() + ' ' + step.getText()));
        Element stepRow = this.div("step-row", stepContainer, this.div("time-cell " + extraClass, this.formatter.format(result.getDurationMillis())));
        if (isBackground) {
            stepRow.setAttribute("data-parent", scenarioMeta + "bg");
        }
        parent.appendChild(stepRow);
        if (step.getTable() != null) {
            Element table = this.node("table", null);
            table.setAttribute("data-parent", refNum);
            parent.appendChild(table);
            for (List list2 : step.getTable().getRows()) {
                Element tr = this.node("tr", null);
                table.appendChild(tr);
                for (String cell : list2) {
                    tr.appendChild(this.node("td", null, cell));
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (step.getDocString() != null) {
            sb.append(step.getDocString());
        }
        if (stepResult.isShowLog() && stepResult.getStepLog() != null) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(stepResult.getStepLog());
        }
        if (result.isFailed()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(result.getError().getMessage());
        }
        if (sb.length() > 0) {
            Element docStringNode = this.node("div", "preformatted", sb.toString());
            docStringNode.setAttribute("data-parent", refNum);
            parent.appendChild(docStringNode);
        }
        if ((embeds = stepResult.getEmbeds()) != null) {
            for (Embed embed : embeds) {
                Element embedNode;
                String mimeType = embed.getMimeType().toLowerCase();
                if (mimeType.contains("image")) {
                    embedNode = this.node("img", null);
                    String src = embed.getAsHtmlData();
                    XmlUtils.addAttributes(embedNode, Collections.singletonMap("src", src));
                } else if (mimeType.contains("html")) {
                    Node html;
                    try {
                        html = XmlUtils.toXmlDoc(embed.getAsString()).getDocumentElement();
                    }
                    catch (Exception e) {
                        html = this.div(null, e.getMessage());
                    }
                    html = this.doc.importNode(html, true);
                    embedNode = this.div(null, html);
                } else {
                    embedNode = this.div(null, new Node[0]);
                    embedNode.setTextContent(embed.getAsString());
                }
                Element embedContainer = this.div("embed", embedNode);
                embedContainer.setAttribute("data-parent", refNum);
                parent.appendChild(embedContainer);
            }
        }
        if ((list = stepResult.getCallResults()) != null) {
            int index = 1;
            for (FeatureResult callResult : list) {
                this.callHtml(isBackground, scenarioMeta, callResult, parent, depth, refNum + "." + index++);
            }
        }
    }

    private void callHtml(boolean isBackground, String scenarioMeta, FeatureResult featureResult, Node parent, int depth, String callRefNum) {
        String callArg;
        List<StepResult> stepResults = featureResult.getAllScenarioStepResultsNotHidden();
        if (stepResults.isEmpty()) {
            return;
        }
        String extraClass = featureResult.isFailed() ? "failed" : "passed";
        Element stepContainer = this.div("step-container", new Node[0]);
        stepContainer.setAttribute("id", callRefNum);
        stepContainer.appendChild(this.div("step-ref " + (isBackground ? "bg-step" : extraClass), ">>"));
        for (int i = 0; i < depth; ++i) {
            stepContainer.appendChild(this.div("step-indent", " "));
        }
        stepContainer.appendChild(this.div("step-cell " + extraClass, featureResult.getCallName()));
        Element stepRow = this.div("step-row", stepContainer, this.div("time-cell " + extraClass, this.formatter.format(featureResult.getDurationMillis())));
        parent.appendChild(stepRow);
        if (isBackground) {
            stepRow.setAttribute("data-parent", scenarioMeta + "bg");
        }
        if ((callArg = featureResult.getCallArgPretty()) != null) {
            Element callArgContainer = this.div("callarg-container", new Node[0]);
            callArgContainer.setAttribute("data-parent", callRefNum);
            parent.appendChild(callArgContainer);
            callArgContainer.appendChild(this.div("step-ref", " "));
            for (int i = 0; i < depth; ++i) {
                callArgContainer.appendChild(this.div("step-indent", " "));
            }
            callArgContainer.appendChild(this.node("div", "preformatted", callArg));
        }
        for (StepResult sr : stepResults) {
            this.stepHtml(isBackground, scenarioMeta, sr, parent, depth + 1);
        }
    }

    public static File saveFeatureResult(String targetDir, FeatureResult result) {
        HtmlFeatureReport report = new HtmlFeatureReport(result);
        return report.save(targetDir);
    }

    private HtmlFeatureReport(FeatureResult featureResult) {
        this.featureResult = featureResult;
        Feature feature = featureResult.getFeature();
        this.set("/html/head/title", featureResult.getPackageQualifiedName());
        this.setById("nav-type", "Scenarios");
        this.setById("nav-pass", featureResult.getPassedCount() + "");
        this.setById("nav-fail", featureResult.getFailedCount() + "");
        String featureName = featureResult.getDisplayUri();
        String featureDescription = feature.getNameAndDescription();
        Element featureHeading = this.div("page-heading alert alert-primary", this.summaryLink(), this.node("span", "feature-label", "|"), this.tagsLink(), this.node("span", "feature-label", "|"), this.node("span", "feature-label", "Feature:"), this.node("span", "feature-name", featureName), this.node("span", "feature-description", featureDescription));
        this.contentContainer.appendChild(featureHeading);
        for (ScenarioResult sr : featureResult.getScenarioResults()) {
            Element scenarioDiv = this.div("scenario", new Node[0]);
            this.contentContainer.appendChild(scenarioDiv);
            Scenario scenario = sr.getScenario();
            String scenarioMeta = scenario.getDisplayMeta();
            String scenarioName = scenario.getNameAndDescription();
            String extraClass = sr.isFailed() ? "failed" : "passed";
            Tags tags = scenario.getTagsEffective();
            Element tagsDiv = this.div("scenario-tags", new Node[0]);
            for (Tag tag : tags.getOriginal()) {
                Element tagLink = this.node("a", "badge badge-primary");
                tagsDiv.appendChild(tagLink);
                tagLink.setAttribute("href", "karate-tags.html");
                tagLink.setTextContent(tag.getText());
            }
            Element headingContainer = this.div("heading-container", tagsDiv, this.node("span", "scenario-keyword", scenario.getKeyword() + ": " + scenarioMeta), this.node("span", "scenario-name", scenarioName));
            String duration = this.formatter.format(sr.getDurationMillis());
            Element scenarioHeadingDiv = this.div("scenario-heading", headingContainer, this.div("scenario-time " + extraClass, "ms: " + duration));
            scenarioHeadingDiv.setAttribute("id", scenarioMeta);
            scenarioDiv.appendChild(scenarioHeadingDiv);
            Element scenarioNav = this.div("nav-item " + extraClass, new Node[0]);
            this.navContainer.appendChild(scenarioNav);
            Element scenarioLink = this.node("a", null, scenarioMeta + " " + scenarioName);
            scenarioNav.appendChild(scenarioLink);
            scenarioLink.setAttribute("href", "#" + scenarioMeta);
            List<StepResult> stepResults = sr.getStepResults();
            if (!stepResults.isEmpty() && stepResults.get(0).getStep().isBackground()) {
                Element bgContainer = this.div("step-container", new Node[0]);
                bgContainer.setAttribute("id", scenarioMeta + "bg");
                bgContainer.appendChild(this.div("step-ref bg-step", ">>"));
                bgContainer.appendChild(this.div("step-cell passed", "Background:"));
                Element bgRow = this.div("step-row", bgContainer, this.div("time-cell passed", ""));
                scenarioDiv.appendChild(bgRow);
            }
            for (StepResult stepResult : stepResults) {
                this.stepHtml(false, scenarioMeta, stepResult, scenarioDiv, 0);
            }
        }
    }

    private File save(String targetDir) {
        return this.saveHtmlToFile(targetDir, HtmlFeatureReport.getHtmlFileName(this.featureResult));
    }
}

