/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.ScriptBindings;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class Tags
implements Iterable<Tag> {
    public static final Tags EMPTY = new Tags(Collections.EMPTY_LIST);
    private final Collection<Tag> original;
    private final List<String> tags;
    private Map<String, List<String>> tagValues;
    private final Bindings bindings;

    @Override
    public Iterator<Tag> iterator() {
        return this.original.iterator();
    }

    public static Tags merge(List<Tag> ... lists) {
        HashSet<Tag> tags = new HashSet<Tag>();
        for (List<Tag> list : lists) {
            if (list == null) continue;
            tags.addAll(list);
        }
        return new Tags(tags);
    }

    public boolean evaluate(String tagSelector) {
        if (tagSelector == null) {
            return true;
        }
        ScriptValue sv = ScriptBindings.eval(tagSelector, this.bindings);
        return sv.isBooleanTrue();
    }

    public boolean contains(String tagText) {
        return this.tags.contains(Tags.removeTagPrefix(tagText));
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Collection<String> getTagKeys() {
        return this.tagValues.keySet();
    }

    public Map<String, List<String>> getTagValues() {
        return this.tagValues;
    }

    public Collection<Tag> getOriginal() {
        return this.original;
    }

    public Tags(Collection<Tag> in) {
        if (in == null) {
            this.original = Collections.EMPTY_LIST;
            this.tags = Collections.EMPTY_LIST;
        } else {
            this.original = in;
            this.tags = new ArrayList<String>(in.size());
            this.tagValues = new HashMap<String, List<String>>(in.size());
            for (Tag tag : in) {
                this.tags.add(tag.getText());
                this.tagValues.put(tag.getName(), tag.getValues());
            }
        }
        this.bindings = ScriptBindings.createBindings();
        this.bindings.put("bridge", (Object)this);
        ScriptValue anyOfFun = ScriptBindings.eval("function(){ return bridge.anyOf(arguments) }", this.bindings);
        ScriptValue allOfFun = ScriptBindings.eval("function(){ return bridge.allOf(arguments) }", this.bindings);
        ScriptValue notFun = ScriptBindings.eval("function(){ return bridge.not(arguments) }", this.bindings);
        ScriptValue valuesForFun = ScriptBindings.eval("function(s){ return bridge.valuesFor(s) }", this.bindings);
        this.bindings.put("anyOf", anyOfFun.getValue());
        this.bindings.put("allOf", allOfFun.getValue());
        this.bindings.put("not", notFun.getValue());
        this.bindings.put("valuesFor", valuesForFun.getValue());
    }

    private static String removeTagPrefix(String s) {
        if (s.charAt(0) == '@') {
            return s.substring(1);
        }
        return s;
    }

    private static Collection<String> removeTagPrefix(Collection<Object> c) {
        ArrayList<String> list = new ArrayList<String>(c.size());
        for (Object o : c) {
            String s = o.toString();
            list.add(Tags.removeTagPrefix(s));
        }
        return list;
    }

    public boolean anyOf(ScriptObjectMirror som) {
        for (String s : Tags.removeTagPrefix(som.values())) {
            if (!this.tags.contains(s)) continue;
            return true;
        }
        return false;
    }

    public boolean allOf(ScriptObjectMirror som) {
        return this.tags.containsAll(Tags.removeTagPrefix(som.values()));
    }

    public boolean not(ScriptObjectMirror som) {
        return !this.anyOf(som);
    }

    public Values valuesFor(String name) {
        List<String> list = this.tagValues.get(Tags.removeTagPrefix(name));
        return new Values(list);
    }

    public static List<Map> toResultList(List<Tag> tags) {
        ArrayList<Map> list = new ArrayList<Map>(tags.size());
        for (Tag tag : tags) {
            HashMap<String, Object> tagMap = new HashMap<String, Object>(2);
            tagMap.put("line", tag.getLine());
            tagMap.put("name", '@' + tag.getText());
            list.add(tagMap);
        }
        return list;
    }

    public static String fromKarateOptionsTags(List<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return null;
        }
        return Tags.fromKarateOptionsTags(tags.toArray(new String[0]));
    }

    public static String fromKarateOptionsTags(String ... tags) {
        if (tags == null || tags.length == 0) {
            return null;
        }
        for (String s : tags) {
            if (s.indexOf(40) == -1) continue;
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tags.length; ++i) {
            String and = StringUtils.trimToEmpty(tags[i]);
            if (and.startsWith("~")) {
                sb.append("not('").append(and.substring(1)).append("')");
            } else {
                sb.append("anyOf(");
                List<String> or = StringUtils.split(and, ',');
                for (String tag : or) {
                    sb.append('\'').append(tag).append('\'').append(',');
                }
                sb.setLength(sb.length() - 1);
                sb.append(')');
            }
            if (i >= tags.length - 1) continue;
            sb.append(" && ");
        }
        return sb.toString();
    }

    public static class Values {
        public final List<String> values;
        public final boolean isPresent;

        public Values(List<String> values) {
            this.values = values == null ? Collections.EMPTY_LIST : values;
            this.isPresent = !this.values.isEmpty();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public boolean isAnyOf(String ... args) {
            for (String s : args) {
                if (!this.values.contains(s)) continue;
                return true;
            }
            return false;
        }

        public boolean isAllOf(String ... args) {
            return this.values.containsAll(Arrays.asList(args));
        }

        public boolean isOnly(String ... args) {
            return this.isAllOf(args) && args.length == this.values.size();
        }

        public boolean isEach(ScriptObjectMirror som) {
            if (!som.isFunction()) {
                return false;
            }
            for (String s : this.values) {
                Object o = som.call((Object)som, new Object[]{s});
                ScriptValue sv = new ScriptValue(o);
                if (sv.isBooleanTrue()) continue;
                return false;
            }
            return true;
        }
    }
}

