/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.core.AutoDef;
import com.intuit.karate.core.Plugin;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverMouse;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.ElementFinder;
import com.intuit.karate.driver.Finder;
import com.intuit.karate.driver.Keys;
import com.intuit.karate.driver.Mouse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Driver
extends Plugin {
    public static final List<String> METHOD_NAMES = Plugin.methodNames(Driver.class);

    @AutoDef
    public void activate();

    @AutoDef
    public void refresh();

    @AutoDef
    public void reload();

    @AutoDef
    public void back();

    @AutoDef
    public void forward();

    @AutoDef
    public void maximize();

    @AutoDef
    public void minimize();

    @AutoDef
    public void fullscreen();

    @AutoDef
    public void close();

    @AutoDef
    public void quit();

    @AutoDef
    public void switchPage(String var1);

    @AutoDef
    public void switchFrame(int var1);

    @AutoDef
    public void switchFrame(String var1);

    public String getUrl();

    public void setUrl(String var1);

    public Map<String, Object> getDimensions();

    public void setDimensions(Map<String, Object> var1);

    public String getTitle();

    public List<String> getPages();

    public String getDialog();

    @AutoDef
    public byte[] screenshot(boolean var1);

    @AutoDef
    default public byte[] screenshot() {
        return this.screenshot(true);
    }

    @AutoDef
    public Map<String, Object> cookie(String var1);

    @AutoDef
    public void cookie(Map<String, Object> var1);

    @AutoDef
    public void deleteCookie(String var1);

    @AutoDef
    public void clearCookies();

    public List<Map> getCookies();

    @AutoDef
    public void dialog(boolean var1);

    @AutoDef
    public void dialog(boolean var1, String var2);

    @AutoDef
    public Object script(String var1);

    @AutoDef
    public boolean waitUntil(String var1);

    @AutoDef
    public Driver submit();

    @AutoDef
    default public Driver retry() {
        return this.retry(null, null);
    }

    @AutoDef
    default public Driver retry(int count) {
        return this.retry(count, null);
    }

    @AutoDef
    default public Driver retry(Integer count, Integer interval) {
        this.getOptions().enableRetry(count, interval);
        return this;
    }

    @AutoDef
    default public Driver delay(int millis) {
        this.getOptions().sleep(millis);
        return this;
    }

    @AutoDef
    public Driver timeout(Integer var1);

    @AutoDef
    public Driver timeout();

    @AutoDef
    public Element focus(String var1);

    @AutoDef
    public Element clear(String var1);

    @AutoDef
    public Element click(String var1);

    @AutoDef
    public Element input(String var1, String var2);

    @AutoDef
    default public Element input(String locator, String[] values) {
        return this.input(locator, values, 0);
    }

    @AutoDef
    default public Element input(String locator, String chars, int delay) {
        String[] array = new String[chars.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Character.toString(chars.charAt(i));
        }
        return this.input(locator, array, delay);
    }

    @AutoDef
    default public Element input(String locator, String[] values, int delay) {
        Element element = DriverElement.locatorUnknown(this, locator);
        for (String value : values) {
            if (delay > 0) {
                this.delay(delay);
            }
            element = this.input(locator, value);
        }
        return element;
    }

    @AutoDef
    public Element select(String var1, String var2);

    @AutoDef
    public Element select(String var1, int var2);

    @AutoDef
    public Element value(String var1, String var2);

    @AutoDef
    default public Element waitFor(String locator) {
        return this.getOptions().waitForAny(this, locator);
    }

    @AutoDef
    default public String waitForUrl(String expected) {
        return this.getOptions().waitForUrl(this, expected);
    }

    @AutoDef
    default public Element waitForText(String locator, String expected) {
        return this.waitUntil(locator, "_.textContent.includes('" + expected + "')");
    }

    @AutoDef
    default public Element waitForEnabled(String locator) {
        return this.waitUntil(locator, "!_.disabled");
    }

    @AutoDef
    default public List<Element> waitForResultCount(String locator, int count) {
        return (List)this.waitUntil(() -> {
            List<Element> list = this.locateAll(locator);
            return list.size() == count ? list : null;
        });
    }

    @AutoDef
    default public List waitForResultCount(String locator, int count, String expression) {
        return (List)this.waitUntil(() -> {
            List list = this.scriptAll(locator, expression);
            return list.size() == count ? list : null;
        });
    }

    @AutoDef
    default public Element waitForAny(String locator1, String locator2) {
        return this.getOptions().waitForAny(this, locator1, locator2);
    }

    @AutoDef
    default public Element waitForAny(String[] locators) {
        return this.getOptions().waitForAny(this, locators);
    }

    @AutoDef
    default public Element waitUntil(String locator, String expression) {
        return this.getOptions().waitUntil(this, locator, expression);
    }

    @AutoDef
    default public Object waitUntil(Supplier<Object> condition) {
        return this.getOptions().retry(() -> condition.get(), o -> o != null, "waitUntil (function)", true);
    }

    @AutoDef
    default public Element locate(String locator) {
        Element e = DriverElement.locatorUnknown(this, locator);
        if (e.isPresent()) {
            return e;
        }
        throw new RuntimeException("cannot find locator: " + locator);
    }

    @AutoDef
    default public List<Element> locateAll(String locator) {
        return this.getOptions().findAll(this, locator);
    }

    @AutoDef
    default public List<Element> locateAll(String locator, Predicate predicate) {
        List<Element> before = this.locateAll(locator);
        ArrayList<Element> after = new ArrayList<Element>(before.size());
        for (Element o : before) {
            if (!predicate.test(o)) continue;
            after.add(o);
        }
        return after;
    }

    @AutoDef
    default public Element scroll(String locator) {
        this.script(locator, "function(e){ var d = window.getComputedStyle(e).display; while(d == 'none'){ e = e.parentElement; d = window.getComputedStyle(e).display } e.scrollIntoView({block: 'center'}) }");
        return DriverElement.locatorExists(this, locator);
    }

    @AutoDef
    default public Element highlight(String locator) {
        return this.highlight(locator, 3000);
    }

    default public Element highlight(String locator, int millis) {
        this.script(this.getOptions().highlight(locator, millis));
        this.delay(millis);
        return DriverElement.locatorExists(this, locator);
    }

    @AutoDef
    default public void highlightAll(String locator) {
        this.highlightAll(locator, 3000);
    }

    default public void highlightAll(String locator, int millis) {
        this.script(this.getOptions().highlightAll(locator, millis));
        this.delay(millis);
    }

    @AutoDef
    default public Finder rightOf(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.RIGHT);
    }

    @AutoDef
    default public Finder leftOf(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.LEFT);
    }

    @AutoDef
    default public Finder above(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.ABOVE);
    }

    @AutoDef
    default public Finder below(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.BELOW);
    }

    @AutoDef
    default public Finder near(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.NEAR);
    }

    @AutoDef
    default public Mouse mouse() {
        return new DriverMouse(this);
    }

    @AutoDef
    default public Mouse mouse(String locator) {
        return new DriverMouse(this).move(locator);
    }

    @AutoDef
    default public Mouse mouse(int x, int y) {
        return new DriverMouse(this).move(x, y);
    }

    @AutoDef
    default public Keys keys() {
        return new Keys(this);
    }

    @AutoDef
    public void actions(List<Map<String, Object>> var1);

    @AutoDef
    public String html(String var1);

    @AutoDef
    public String text(String var1);

    @AutoDef
    public String value(String var1);

    @AutoDef
    public String attribute(String var1, String var2);

    @AutoDef
    public String property(String var1, String var2);

    @AutoDef
    public boolean enabled(String var1);

    @AutoDef
    default public boolean exists(String locator) {
        return this.getOptions().optional(this, locator).isPresent();
    }

    @AutoDef
    default public Element optional(String locator) {
        return this.getOptions().optional(this, locator);
    }

    @AutoDef
    public Map<String, Object> position(String var1);

    @AutoDef
    public byte[] screenshot(String var1, boolean var2);

    @AutoDef
    default public byte[] screenshot(String locator) {
        return this.screenshot(locator, true);
    }

    @AutoDef
    default public Object script(String locator, String expression) {
        String js = this.getOptions().scriptSelector(locator, expression);
        return this.script(js);
    }

    @AutoDef
    default public List scriptAll(String locator, String expression) {
        String js = this.getOptions().scriptAllSelector(locator, expression);
        return (List)this.script(js);
    }

    @AutoDef
    default public List scriptAll(String locator, String expression, Predicate predicate) {
        List before = this.scriptAll(locator, expression);
        ArrayList after = new ArrayList(before.size());
        for (Object o : before) {
            if (!predicate.test(o)) continue;
            after.add(o);
        }
        return after;
    }

    public DriverOptions getOptions();

    public Object elementId(String var1);

    public List elementIds(String var1);

    @Override
    default public List<String> methodNames() {
        return METHOD_NAMES;
    }

    @Override
    default public void setContext(ScenarioContext context) {
        this.getOptions().setContext(context);
    }

    @Override
    default public Map<String, Object> afterScenario() {
        return Collections.EMPTY_MAP;
    }
}

