/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.Finder;
import com.intuit.karate.driver.MissingElement;
import com.intuit.karate.driver.Mouse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DriverElement
implements Element {
    private final Driver driver;
    private final String locator;
    private Boolean exists;

    private DriverElement(Driver driver, String locator, Boolean exists) {
        this.driver = driver;
        this.locator = locator;
        this.exists = exists;
    }

    public static Element locatorExists(Driver driver, String locator) {
        return new DriverElement(driver, locator, true);
    }

    public static Element locatorUnknown(Driver driver, String locator) {
        return new DriverElement(driver, locator, null);
    }

    @Override
    public String getLocator() {
        return this.locator;
    }

    @Override
    public boolean isPresent() {
        if (this.exists == null) {
            this.exists = this.driver.optional(this.locator).isPresent();
        }
        return this.exists;
    }

    public void setExists(Boolean exists) {
        this.exists = exists;
    }

    @Override
    public Map<String, Object> getPosition() {
        return this.driver.position(this.locator);
    }

    @Override
    public byte[] screenshot() {
        return this.driver.screenshot();
    }

    @Override
    public boolean isEnabled() {
        return this.driver.enabled(this.locator);
    }

    @Override
    public Element highlight() {
        return this.driver.highlight(this.locator);
    }

    @Override
    public Element focus() {
        return this.driver.focus(this.locator);
    }

    @Override
    public Element clear() {
        return this.driver.clear(this.locator);
    }

    @Override
    public Element click() {
        return this.driver.click(this.locator);
    }

    @Override
    public Element submit() {
        this.driver.submit();
        return this;
    }

    @Override
    public Mouse mouse() {
        return this.driver.mouse(this.locator);
    }

    @Override
    public Element input(String value) {
        return this.driver.input(this.locator, value);
    }

    @Override
    public Element input(String[] values) {
        return this.driver.input(this.locator, values);
    }

    @Override
    public Element input(String[] values, int delay) {
        return this.driver.input(this.locator, values, delay);
    }

    @Override
    public Element select(String text) {
        return this.driver.select(this.locator, text);
    }

    @Override
    public Element select(int index) {
        return this.driver.select(this.locator, index);
    }

    @Override
    public Element switchFrame() {
        this.driver.switchFrame(this.locator);
        return this;
    }

    @Override
    public Element delay(int millis) {
        this.driver.delay(millis);
        return this;
    }

    @Override
    public Element retry() {
        this.driver.retry();
        return this;
    }

    @Override
    public Element retry(int count) {
        this.driver.retry(count);
        return this;
    }

    @Override
    public Element retry(Integer count, Integer interval) {
        this.driver.retry(count, interval);
        return this;
    }

    @Override
    public Element waitFor() {
        this.driver.waitFor(this.locator);
        return this;
    }

    @Override
    public Element waitForText(String text) {
        return this.driver.waitForText(this.locator, text);
    }

    @Override
    public Element waitUntil(String expression) {
        return this.driver.waitUntil(this.locator, expression);
    }

    @Override
    public Object script(String expression) {
        return this.driver.script(this.locator, expression);
    }

    private String thisLocator() {
        String thisRef = (String)this.driver.script(this.locator, "function(e){ if (!document._karate) document._karate = { seq: (new Date()).getTime() }; var ref = 'ref' + document._karate.seq++; document._karate[ref] = e; return ref }");
        return DriverOptions.karateLocator(thisRef);
    }

    @Override
    public Element optional(String locator) {
        String childRefScript = this.driver.getOptions().scriptSelector(locator, "function(e){ if (!document._karate) document._karate = { seq: (new Date()).getTime() }; var ref = 'ref' + document._karate.seq++; document._karate[ref] = e; return ref }", this.thisLocator());
        try {
            String childRef = (String)this.driver.script(childRefScript);
            return DriverElement.locatorExists(this.driver, DriverOptions.karateLocator(childRef));
        }
        catch (Exception e) {
            return new MissingElement(this.driver, locator);
        }
    }

    @Override
    public boolean exists(String locator) {
        return this.optional(locator).isPresent();
    }

    @Override
    public Element locate(String locator) {
        Element e = this.optional(locator);
        if (e.isPresent()) {
            return e;
        }
        throw new RuntimeException("cannot find locator: " + locator);
    }

    @Override
    public List<Element> locateAll(String locator) {
        String childRefScript = this.driver.getOptions().scriptAllSelector(locator, "function(e){ if (!document._karate) document._karate = { seq: (new Date()).getTime() }; var ref = 'ref' + document._karate.seq++; document._karate[ref] = e; return ref }", this.thisLocator());
        List childRefs = (List)this.driver.script(childRefScript);
        ArrayList<Element> elements = new ArrayList<Element>(childRefs.size());
        for (String childRef : childRefs) {
            String karateLocator = DriverOptions.karateLocator(childRef);
            elements.add(DriverElement.locatorExists(this.driver, karateLocator));
        }
        return elements;
    }

    @Override
    public String attribute(String name) {
        return this.driver.attribute(this.locator, name);
    }

    @Override
    public String property(String name) {
        return this.driver.property(this.locator, name);
    }

    @Override
    public String getHtml() {
        return this.driver.html(this.locator);
    }

    @Override
    public void setHtml(String html) {
        this.driver.script(this.locator, "_.outerHTML = '" + html + "'");
    }

    @Override
    public String getText() {
        return this.driver.text(this.locator);
    }

    @Override
    public void setText(String text) {
        this.driver.script(this.locator, "_.innerHTML = '" + text + "'");
    }

    @Override
    public String getValue() {
        return this.driver.value(this.locator);
    }

    @Override
    public void setValue(String value) {
        this.driver.value(this.locator, value);
    }

    @Override
    public Finder rightOf() {
        return this.driver.rightOf(this.locator);
    }

    @Override
    public Finder leftOf() {
        return this.driver.leftOf(this.locator);
    }

    @Override
    public Finder above() {
        return this.driver.above(this.locator);
    }

    @Override
    public Finder below() {
        return this.driver.below(this.locator);
    }

    @Override
    public Finder near() {
        return this.driver.near(this.locator);
    }
}

