/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.appium;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Json;
import com.intuit.karate.core.Embed;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.WebDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public abstract class AppiumDriver
extends WebDriver {
    protected AppiumDriver(DriverOptions options) {
        super(options);
    }

    @Override
    public String attribute(String locator, String name) {
        String id = this.elementId(locator);
        return this.http.path("element", id, "attribute", name).get().jsonPath("$.value").asString();
    }

    @Override
    protected String selectorPayload(String id) {
        Json json = new Json();
        if (id.startsWith("/")) {
            json.set("using", "xpath").set("value", id);
        } else if (id.startsWith("@")) {
            json.set("using", "accessibility id").set("value", id.substring(1));
        } else if (id.startsWith("#")) {
            json.set("using", "id").set("value", id.substring(1));
        } else if (id.startsWith(":")) {
            json.set("using", "-ios predicate string").set("value", id.substring(1));
        } else if (id.startsWith("^")) {
            json.set("using", "-ios class chain").set("value", id.substring(1));
        } else if (id.startsWith("-")) {
            json.set("using", "-android uiautomator").set("value", id.substring(1));
        } else {
            json.set("using", "name").set("value", id);
        }
        return json.toString();
    }

    @Override
    public Element click(String locator) {
        String id = this.elementId(locator);
        this.http.path("element", id, "click").post("{}");
        return DriverElement.locatorExists(this, locator);
    }

    public void setContext(String context) {
        Json contextBody = new Json();
        contextBody.set("name", context);
        this.http.path("context").post(contextBody);
    }

    public void hideKeyboard() {
        this.http.path("appium", "device", "hide_keyboard").post("{}");
    }

    public String startRecordingScreen() {
        return this.http.path("appium", "start_recording_screen").post("{}").jsonPath("$.value").asString();
    }

    public String startRecordingScreen(Map<String, Object> payload) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("options", payload);
        return this.http.path("appium", "start_recording_screen").post(options).jsonPath("$.value").asString();
    }

    public String stopRecordingScreen() {
        return this.http.path("appium", "stop_recording_screen").post("{}").jsonPath("$.value").asString();
    }

    public String stopRecordingScreen(Map<String, Object> payload) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("options", payload);
        return this.http.path("appium", "stop_recording_screen").post(options).jsonPath("$.value").asString();
    }

    public void saveRecordingScreen(String fileName, boolean embed) {
        String videoTemp = this.stopRecordingScreen();
        byte[] bytes = Base64.getDecoder().decode(videoTemp);
        File src = new File(fileName);
        try (FileOutputStream fileOutputStream = new FileOutputStream(src.getAbsolutePath());){
            fileOutputStream.write(bytes);
        }
        catch (Exception e) {
            this.logger.error("error while saveRecordingScreen {}", e.getMessage());
        }
        if (embed && src.exists()) {
            String path = FileUtils.getBuildDir() + File.separator + System.currentTimeMillis() + ".mp4";
            File dest = new File(path);
            FileUtils.copy(src, dest);
            this.options.embedContent(Embed.forVideoFile("../" + dest.getName()));
        }
    }

    public void saveRecordingScreen(String fileName) {
        this.saveRecordingScreen(fileName, false);
    }

    @Override
    public String text(String locator) {
        String id = this.elementId(locator);
        return this.http.path("element", id, "text").get().jsonPath("$.value").asString();
    }
}

