/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.chrome;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.LogAppender;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WebDriver;
import java.util.Map;

public class ChromeWebDriver
extends WebDriver {
    public ChromeWebDriver(DriverOptions options) {
        super(options);
    }

    public static ChromeWebDriver start(ScenarioContext context, Map<String, Object> map, LogAppender appender) {
        DriverOptions options = new DriverOptions(context, map, appender, 9515, "chromedriver");
        options.arg("--port=" + options.port);
        options.arg("--user-data-dir=" + options.workingDirPath);
        return new ChromeWebDriver(options);
    }

    @Override
    public void activate() {
        if (!this.options.headless) {
            try {
                switch (FileUtils.getOsType()) {
                    case MACOSX: {
                        Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell app \"Chrome\" to activate"});
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("native window switch failed: {}", e.getMessage());
            }
        }
    }

    @Override
    protected boolean isJavaScriptError(Http.Response res) {
        ScriptValue value = res.jsonPath("$.value").value();
        return !value.isNull() && value.getAsString().contains("javascript error");
    }

    @Override
    protected boolean isLocatorError(Http.Response res) {
        ScriptValue value = res.jsonPath("$.value").value();
        return value.getAsString().contains("no such element");
    }

    @Override
    protected boolean isCookieError(Http.Response res) {
        ScriptValue value = res.jsonPath("$.value").value();
        return !value.isNull() && value.getAsString().contains("unable to set cookie");
    }
}

