/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.job.ChunkResult;
import com.intuit.karate.job.JobContext;
import com.intuit.karate.job.JobMessage;
import com.intuit.karate.job.JobServer;
import com.intuit.karate.job.JobServerHandler;

public class ScenarioJobServerHandler
extends JobServerHandler {
    public ScenarioJobServerHandler(JobServer server) {
        super(server);
    }

    @Override
    protected JobMessage handle(JobMessage jm) {
        String method;
        switch (method = jm.method) {
            case "error": {
                this.dumpLog(jm);
                return new JobMessage("error");
            }
            case "heartbeat": {
                logger.info("hearbeat: {}", (Object)jm);
                return new JobMessage("heartbeat");
            }
            case "download": {
                logger.info("download: {}", (Object)jm);
                JobMessage download = new JobMessage("download");
                download.setBytes(this.server.getDownload());
                int executorId = this.server.executorCounter.getAndIncrement();
                download.setExecutorId(executorId + "");
                return download;
            }
            case "init": {
                logger.info("init: {}", (Object)jm);
                JobMessage init = new JobMessage("init");
                init.put("startupCommands", this.server.config.getStartupCommands());
                init.put("shutdownCommands", this.server.config.getShutdownCommands());
                init.put("environment", this.server.config.getEnvironment());
                init.put("uploadDir", this.server.resolveUploadDir());
                return init;
            }
            case "next": {
                logger.info("next: {}", (Object)jm);
                ChunkResult chunk = this.server.getNextChunk(jm.getExecutorId());
                if (chunk == null) {
                    logger.info("no more chunks, server responding with 'stop' message");
                    return new JobMessage("stop");
                }
                String uploadDir = jm.get("uploadDir", String.class);
                JobContext jc = new JobContext(chunk.scenario, this.server.jobId, jm.getExecutorId(), chunk.getChunkId(), uploadDir);
                JobMessage next = new JobMessage("next").put("preCommands", this.server.config.getPreCommands(jc)).put("mainCommands", this.server.config.getMainCommands(jc)).put("postCommands", this.server.config.getPostCommands(jc));
                next.setChunkId(chunk.getChunkId());
                return next;
            }
            case "upload": {
                logger.info("upload: {}", (Object)jm);
                this.server.handleUpload(jm.getBytes(), jm.getExecutorId(), jm.getChunkId());
                return new JobMessage("upload");
            }
        }
        logger.warn("unknown request method: {}", (Object)method);
        return null;
    }
}

