/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureBackend;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.netty.FeatureServerHandler;
import com.intuit.karate.netty.NettyUtils;
import io.netty.karate.bootstrap.ServerBootstrap;
import io.netty.karate.channel.Channel;
import io.netty.karate.channel.ChannelInitializer;
import io.netty.karate.channel.ChannelPipeline;
import io.netty.karate.channel.EventLoopGroup;
import io.netty.karate.channel.nio.NioEventLoopGroup;
import io.netty.karate.channel.socket.nio.NioServerSocketChannel;
import io.netty.karate.handler.codec.http.HttpObjectAggregator;
import io.netty.karate.handler.codec.http.HttpServerCodec;
import io.netty.karate.handler.ssl.SslContext;
import io.netty.karate.handler.ssl.SslContextBuilder;
import io.netty.karate.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureServer {
    private static final Logger logger = LoggerFactory.getLogger(FeatureServer.class);
    public static final String DEFAULT_CERT_NAME = "cert.pem";
    public static final String DEFAULT_KEY_NAME = "key.pem";
    private final Channel channel;
    private final String host;
    private final int port;
    private final boolean ssl;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final FeatureBackend backend;

    public static FeatureServer start(File featureFile, int port, boolean ssl, Map<String, Object> arg) {
        return new FeatureServer(featureFile, port, ssl, arg);
    }

    public static FeatureServer start(File featureFile, int port, boolean ssl, File certFile, File privateKeyFile, Map<String, Object> arg) {
        return new FeatureServer(featureFile, port, ssl, certFile, privateKeyFile, arg);
    }

    public String getBaseUrl() {
        return (this.ssl ? "https" : "http") + "://" + this.host + ":" + this.port;
    }

    public int getPort() {
        return this.port;
    }

    public void waitSync() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        logger.info("stop: shutting down");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        logger.info("stop: shutdown complete");
    }

    private static Supplier<SslContext> getContextSupplier(File certFileProvided, File keyFileProvided) {
        return () -> {
            try {
                File certFile = certFileProvided;
                File keyFile = keyFileProvided;
                if (certFile == null || keyFile == null) {
                    String buildDir = FileUtils.getBuildDir();
                    certFile = new File(buildDir + File.separator + DEFAULT_CERT_NAME);
                    keyFile = new File(buildDir + File.separator + DEFAULT_KEY_NAME);
                }
                if (!certFile.exists() || !keyFile.exists()) {
                    logger.warn("ssl - " + certFile + " and / or " + keyFile + " not found, will create");
                    NettyUtils.createSelfSignedCertificate(certFile, keyFile);
                } else {
                    logger.info("ssl - re-using existing files: {} and {}", (Object)certFile, (Object)keyFile);
                }
                return SslContextBuilder.forServer(certFile, keyFile).build();
            }
            catch (Exception e) {
                logger.warn("failed to create ssl context, will attempt throwaway creation: {}", (Object)e.getMessage());
                try {
                    SelfSignedCertificate ssc = new SelfSignedCertificate();
                    return SslContextBuilder.forServer(ssc.certificate(), ssc.privateKey()).build();
                }
                catch (Exception ee) {
                    throw new RuntimeException(ee);
                }
            }
        };
    }

    private static Supplier<SslContext> getContextSupplierFromStreams(InputStream certStream, InputStream keyStream) {
        return () -> {
            try {
                return SslContextBuilder.forServer(certStream, keyStream).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public FeatureServer(Feature feature, int port, boolean ssl, InputStream certStream, InputStream keyStream, Map<String, Object> arg) {
        this(feature, port, ssl, FeatureServer.getContextSupplierFromStreams(certStream, keyStream), arg);
    }

    private FeatureServer(File file, int port, boolean ssl, File certificate, File privateKey, Map<String, Object> arg) {
        this(FeatureServer.toFeature(file), port, ssl, FeatureServer.getContextSupplier(certificate, privateKey), arg);
    }

    public FeatureServer(Feature feature, int port, boolean ssl, Map<String, Object> arg) {
        this(feature, port, ssl, FeatureServer.getContextSupplier(null, null), arg);
    }

    private FeatureServer(File file, int port, boolean ssl, Map<String, Object> arg) {
        this(FeatureServer.toFeature(file), port, ssl, FeatureServer.getContextSupplier(null, null), arg);
    }

    private static Feature toFeature(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            file = new File(file.getAbsolutePath());
        }
        return FeatureParser.parse(file);
    }

    private FeatureServer(Feature feature, int requestedPort, final boolean ssl, final Supplier<SslContext> contextSupplier, Map<String, Object> arg) {
        this.ssl = ssl;
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        this.backend = new FeatureBackend(feature, arg);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer(){

                protected void initChannel(Channel c) {
                    ChannelPipeline p = c.pipeline();
                    if (ssl) {
                        p.addLast(((SslContext)contextSupplier.get()).newHandler(c.alloc()));
                    }
                    p.addLast(new HttpServerCodec());
                    p.addLast(new HttpObjectAggregator(0x100000));
                    p.addLast(new FeatureServerHandler(FeatureServer.this.backend, ssl, contextSupplier, () -> FeatureServer.this.stop()));
                }
            });
            this.channel = b.bind(requestedPort).sync().channel();
            InetSocketAddress isa = (InetSocketAddress)this.channel.localAddress();
            this.host = "127.0.0.1";
            this.port = isa.getPort();
            logger.info("server started - {}", (Object)this.getBaseUrl());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

