/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.KarateOptions;
import com.intuit.karate.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class RunnerOptions {
    private static final Logger logger = LoggerFactory.getLogger(RunnerOptions.class);
    private static final Pattern COMMAND_NAME = Pattern.compile("--name \"?([^$\"]+[^ \"]+)\"?");
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display this help message"})
    boolean help;
    @CommandLine.Option(names={"-t", "--tags"}, description={"tags"})
    List<String> tags;
    @CommandLine.Option(names={"-T", "--threads"}, description={"threads"})
    int threads = 1;
    @CommandLine.Option(names={"-n", "--name"}, description={"name of scenario to run"})
    String name;
    @CommandLine.Option(names={"-e", "--env"}, description={"value of 'karate.env'"})
    String env;
    @CommandLine.Option(names={"-d", "--debug"}, arity="0..1", defaultValue="-1", fallbackValue="0", description={"debug mode (optional port else dynamically chosen)"})
    int debugPort;
    @CommandLine.Parameters(description={"one or more tests (features) or search-paths to run"})
    List<String> features;
    @CommandLine.Option(names={"-m", "--monochrome"}, description={"monochrome (not supported)"})
    boolean monochrome;
    @CommandLine.Option(names={"-g", "--glue"}, description={"glue (not supported)"})
    String glue;
    @CommandLine.Option(names={"-", "--plugin"}, description={"plugin (not supported)"})
    List<String> plugins;

    public List<String> getTags() {
        return this.tags;
    }

    public String getName() {
        return this.name;
    }

    public void addFeature(String feature) {
        if (this.features == null) {
            this.features = new ArrayList<String>(1);
        }
        this.features.add(feature);
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public static RunnerOptions parseStringArgs(String[] args) {
        RunnerOptions options = (RunnerOptions)CommandLine.populateCommand((Object)new RunnerOptions(), (String[])args);
        ArrayList<String> featuresTemp = new ArrayList<String>();
        if (options.features != null) {
            for (String s : options.features) {
                if (s.startsWith("com.") || s.startsWith("cucumber.") || s.startsWith("org.")) continue;
                featuresTemp.add(s);
            }
            options.features = featuresTemp.isEmpty() ? null : featuresTemp;
        }
        return options;
    }

    public static RunnerOptions parseCommandLine(String line) {
        String nameTemp;
        Matcher matcher = COMMAND_NAME.matcher(line);
        if (matcher.find()) {
            nameTemp = matcher.group(1);
            line = matcher.replaceFirst("");
        } else {
            nameTemp = null;
        }
        String[] args = line.split("\\s+");
        RunnerOptions options = RunnerOptions.parseStringArgs(args);
        options.name = nameTemp;
        if (options.env != null) {
            System.setProperty("karate.env", options.env);
        }
        return options;
    }

    public static RunnerOptions fromAnnotationAndSystemProperties(List<String> features, List<String> tags, Class<?> clazz) {
        RunnerOptions options;
        KarateOptions ko;
        KarateOptions karateOptions = ko = clazz == null ? null : clazz.getAnnotation(KarateOptions.class);
        if (ko != null) {
            if (ko.tags().length > 0) {
                tags = Arrays.asList(ko.tags());
            }
            if (ko.features().length > 0) {
                features = Arrays.asList(ko.features());
            }
        }
        if (clazz != null && (features == null || features.isEmpty())) {
            String relative = FileUtils.toRelativeClassPath(clazz);
            features = Collections.singletonList(relative);
        }
        String line = System.getProperty("karate.options");
        if ((line = StringUtils.trimToNull(line)) == null) {
            options = new RunnerOptions();
            options.tags = tags;
            options.features = features;
        } else {
            logger.info("found system property 'karate.options': {}", (Object)line);
            options = RunnerOptions.parseCommandLine(line);
            if (options.tags == null) {
                options.tags = tags;
            }
            if (options.features == null) {
                options.features = features;
            }
        }
        return options;
    }
}

