/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.StepActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.Tags;
import com.intuit.karate.shell.FileLogAppender;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class ScenarioExecutionUnit
implements Runnable {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(ScenarioExecutionUnit.class);
    public final Scenario scenario;
    private final ExecutionContext exec;
    public final ScenarioResult result;
    private final boolean reportDisabled;
    private boolean executed = false;
    private Collection<ExecutionHook> hooks;
    private List<Step> steps;
    private StepActions actions;
    private boolean stopped = false;
    private boolean aborted = false;
    private StepResult lastStepResult;
    private Runnable next;
    private boolean last;
    private Step currentStep;
    private LogAppender appender;
    private Throwable error;
    private static final ThreadLocal<LogAppender> APPENDER = new ThreadLocal<LogAppender>(){

        @Override
        protected LogAppender initialValue() {
            String fileName = FileUtils.getBuildDir() + File.separator + Thread.currentThread().getName() + ".log";
            return new FileLogAppender(new File(fileName));
        }
    };
    private int stepIndex;

    public Throwable getError() {
        return this.error;
    }

    public Step getCurrentStep() {
        return this.currentStep;
    }

    public ScenarioExecutionUnit(Scenario scenario, List<StepResult> results, ExecutionContext exec) {
        this(scenario, results, exec, null);
    }

    public ScenarioExecutionUnit(Scenario scenario, List<StepResult> results, ExecutionContext exec, ScenarioContext backgroundContext) {
        this.scenario = scenario;
        this.exec = exec;
        this.result = new ScenarioResult(scenario, results);
        if (backgroundContext != null) {
            ScenarioContext context = backgroundContext.copy();
            this.actions = new StepActions(context);
        }
        if (exec.callContext.perfMode) {
            this.appender = LogAppender.NO_OP;
        }
        Tags tags = scenario.getTagsEffective();
        this.reportDisabled = tags.valuesFor("report").isAnyOf("false");
    }

    public ScenarioContext getContext() {
        return this.actions == null ? null : this.actions.context;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public StepActions getActions() {
        return this.actions;
    }

    public void setActions(StepActions actions) {
        this.actions = actions;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setNext(Runnable next) {
        this.next = next;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public boolean isLast() {
        return this.last;
    }

    public void init() {
        boolean initFailed = false;
        if (this.actions == null) {
            try {
                this.actions = new StepActions(this.exec.featureContext, this.exec.callContext, this.exec.classLoader, this.scenario, this.appender);
            }
            catch (Exception e) {
                initFailed = true;
                this.result.addError("scenario init failed", e);
            }
        } else {
            Logger logger = new Logger();
            logger.setAppender(this.appender);
            this.actions.context.setLogger(logger);
        }
        if (!initFailed) {
            this.actions.context.setReportDisabled(this.reportDisabled);
            this.hooks = this.exec.callContext.resolveHooks();
            if (this.hooks != null) {
                try {
                    this.hooks.forEach(h -> h.beforeScenario(this.scenario, this.actions.context));
                }
                catch (Exception e) {
                    initFailed = true;
                    this.result.addError("beforeScenario hook failed", e);
                }
            }
        }
        if (initFailed) {
            this.steps = Collections.EMPTY_LIST;
        } else if (this.scenario.isDynamic()) {
            this.steps = this.scenario.getBackgroundSteps();
        } else {
            this.steps = this.scenario.isBackgroundDone() ? this.scenario.getSteps() : this.scenario.getStepsIncludingBackground();
            if (this.scenario.isOutline()) {
                Map<String, Object> exampleData = this.scenario.getExampleData();
                this.actions.context.vars.put("__row", exampleData);
                this.actions.context.vars.put("__num", (Object)this.scenario.getExampleIndex());
                if (this.actions.context.getConfig().isOutlineVariablesAuto()) {
                    exampleData.forEach((k, v) -> this.actions.context.vars.put((String)k, v));
                }
            }
        }
        this.result.setThreadName(Thread.currentThread().getName());
        this.result.setStartTime(System.currentTimeMillis() - this.exec.startTime);
    }

    public void reset(ScenarioContext context) {
        this.setExecuted(false);
        this.result.reset();
        this.actions = new StepActions(context);
    }

    private StepResult afterStep(StepResult result) {
        if (this.hooks != null) {
            this.hooks.forEach(h -> h.afterStep(result, this.actions.context));
        }
        return result;
    }

    public StepResult execute(Step step) {
        boolean hidden;
        this.currentStep = step;
        this.actions.context.setExecutionUnit(this);
        if (this.hooks != null) {
            boolean shouldExecute = true;
            for (ExecutionHook hook : this.hooks) {
                if (hook.beforeStep(step, this.actions.context)) continue;
                shouldExecute = false;
            }
            if (!shouldExecute) {
                return null;
            }
        }
        boolean bl = hidden = this.reportDisabled || step.isPrefixStar() && !step.isPrint() && !this.actions.context.getConfig().isShowAllSteps();
        if (this.stopped) {
            Result stepResult = this.aborted && this.actions.context.getConfig().isAbortedStepsShouldPass() ? Result.passed(0L) : Result.skipped();
            StepResult sr = new StepResult(step, stepResult, null, null, null);
            sr.setHidden(hidden);
            return this.afterStep(sr);
        }
        Engine.THREAD_CONTEXT.set(this.actions.context);
        Result execResult = Engine.executeStep(step, this.actions);
        Engine.THREAD_CONTEXT.set(null);
        List<FeatureResult> callResults = this.actions.context.getAndClearCallResults();
        List<Embed> embeds = this.actions.context.getAndClearEmbeds();
        if (execResult.isAborted()) {
            this.aborted = true;
            this.actions.context.logger.debug("abort at {}", step.getDebugInfo());
        } else if (execResult.isFailed()) {
            this.error = execResult.getError();
        }
        String stepLog = StringUtils.trimToNull(this.appender.collect());
        boolean showLog = !this.reportDisabled && this.actions.context.getConfig().isShowLog();
        StepResult sr = new StepResult(step, execResult, stepLog, embeds, callResults);
        sr.setHidden(hidden);
        sr.setShowLog(showLog);
        return this.afterStep(sr);
    }

    public void stop() {
        this.result.setEndTime(System.currentTimeMillis() - this.exec.startTime);
        if (this.actions != null) {
            List<Embed> embeds;
            this.actions.context.logLastPerfEvent(this.result.getFailureMessageForDisplay());
            this.actions.context.invokeAfterHookIfConfigured(false);
            if (this.hooks != null) {
                this.hooks.forEach(h -> h.afterScenario(this.result, this.actions.context));
            }
            if ((embeds = this.actions.context.getAndClearEmbeds()) != null) {
                embeds.forEach(embed -> this.lastStepResult.addEmbed((Embed)embed));
            }
            this.actions.context.stop(this.lastStepResult);
        }
        if (this.lastStepResult != null) {
            String stepLog = StringUtils.trimToNull(this.appender.collect());
            this.lastStepResult.appendToStepLog(stepLog);
        }
    }

    public void stepBack() {
        this.stopped = false;
        this.stepIndex -= 2;
        if (this.stepIndex < 0) {
            this.stepIndex = 0;
        }
    }

    public void stepReset() {
        this.stopped = false;
        --this.stepIndex;
        if (this.stepIndex < 0) {
            this.stepIndex = 0;
        }
    }

    public void stepProceed() {
        this.stopped = false;
    }

    private int nextStepIndex() {
        return this.stepIndex++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.appender == null) {
            this.appender = APPENDER.get();
        }
        try {
            if (this.steps == null) {
                this.init();
            }
            int count = this.steps.size();
            int index = 0;
            while ((index = this.nextStepIndex()) < count) {
                Step step = this.steps.get(index);
                this.lastStepResult = this.execute(step);
                if (this.lastStepResult == null) continue;
                this.result.addStepResult(this.lastStepResult);
                if (!this.lastStepResult.isStopped()) continue;
                this.stopped = true;
            }
            this.stop();
        }
        catch (Exception e) {
            this.result.addError("scenario execution failed", e);
            LOGGER.error("scenario execution failed: {}", (Object)e.getMessage());
        }
        finally {
            if (this.next != null) {
                this.next.run();
            }
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }
}

