/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.Table;
import java.util.List;

public class Step {
    private final Feature feature;
    private final Scenario scenario;
    private final int index;
    private int line;
    private int endLine;
    private List<String> comments;
    private String prefix;
    private String text;
    private String docString;
    private Table table;

    public String getDebugInfo() {
        String message = "feature: " + this.feature.getRelativePath();
        if (!this.isBackground()) {
            message = message + ", scenario: " + StringUtils.trimToNull(this.scenario.getName());
        }
        return message + ", line: " + this.line;
    }

    public boolean isPrint() {
        return this.text != null && this.text.startsWith("print");
    }

    public boolean isPrefixStar() {
        return "*".equals(this.prefix);
    }

    protected Step() {
        this(null, null, -1);
    }

    public Step(Feature feature, Scenario scenario, int index) {
        this.feature = feature;
        this.scenario = scenario;
        this.index = index;
    }

    public boolean isBackground() {
        return this.scenario == null;
    }

    public boolean isOutline() {
        return this.scenario != null && this.scenario.isOutline();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLineCount() {
        return this.endLine - this.line + 1;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDocString() {
        return this.docString;
    }

    public void setDocString(String docString) {
        this.docString = docString;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public void setComments(List<String> comments) {
        this.comments = comments;
    }

    public String toString() {
        String temp = this.prefix + " " + this.text;
        if (this.docString != null) {
            temp = temp + "\n\"\"\"\n" + this.docString + "\n\"\"\"";
        }
        if (this.table != null) {
            temp = temp + " " + this.table.toString();
        }
        return temp;
    }
}

