/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.debug;

import com.intuit.karate.FileUtils;
import com.intuit.karate.debug.DapMessage;
import io.netty.karate.buffer.ByteBuf;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DapEncoder
extends MessageToMessageEncoder<DapMessage> {
    private static final Logger logger = LoggerFactory.getLogger(DapEncoder.class);
    private static final byte[] CONTENT_LENGTH_COLON = "Content-Length: ".getBytes(FileUtils.UTF8);
    private static final byte[] CRLFCRLF = "\r\n\r\n".getBytes(FileUtils.UTF8);

    @Override
    protected void encode(ChannelHandlerContext ctx, DapMessage dm, List<Object> out) throws Exception {
        String msg = dm.toJson();
        if (logger.isTraceEnabled()) {
            logger.trace("<< {}", (Object)msg);
        }
        ByteBuf buf = ctx.alloc().buffer();
        byte[] bytes = msg.getBytes(FileUtils.UTF8);
        buf.writeBytes(CONTENT_LENGTH_COLON);
        buf.writeCharSequence(bytes.length + "", FileUtils.UTF8);
        buf.writeBytes(CRLFCRLF);
        buf.writeBytes(bytes);
        out.add(buf);
    }
}

