/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

public class Input {
    protected boolean control;
    protected boolean alt;
    protected boolean shift;
    protected boolean meta;
    private int pos = 0;
    public final char[] chars;

    public Input(String chars) {
        this.chars = chars.toCharArray();
    }

    public boolean hasNext() {
        return this.pos < this.chars.length;
    }

    private void updateModifiers(char c) {
        switch (c) {
            case '\ue009': {
                this.control = !this.control;
                break;
            }
            case '\ue00a': {
                this.alt = !this.alt;
                break;
            }
            case '\ue008': {
                this.shift = !this.shift;
                break;
            }
            case '\ue03d': {
                this.meta = !this.meta;
                break;
            }
        }
    }

    public char next() {
        char c = this.chars[this.pos++];
        this.updateModifiers(c);
        return c;
    }

    public int getModifierFlags() {
        int modifier = 0;
        if (this.control) {
            modifier += 2;
        }
        if (this.alt) {
            ++modifier;
        }
        if (this.shift) {
            modifier += 8;
        }
        if (this.meta) {
            modifier += 4;
        }
        return modifier;
    }
}

