/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.formats.postman;

import com.intuit.karate.formats.postman.PostmanRequest;
import com.intuit.karate.formats.postman.RequestBuilder;
import java.util.List;
import java.util.Optional;

public class PostmanItem {
    private String name;
    private PostmanRequest request;
    private Optional<PostmanItem> parent;
    private Optional<List<PostmanItem>> items = Optional.empty();

    public PostmanItem() {
        this.parent = Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public PostmanRequest getRequest() {
        return this.request;
    }

    public void setRequest(PostmanRequest request) {
        this.request = request;
    }

    public Optional<PostmanItem> getParent() {
        return this.parent;
    }

    public void setParent(Optional<PostmanItem> parent) {
        this.parent = parent;
    }

    public Optional<List<PostmanItem>> getItems() {
        return this.items;
    }

    public void setItems(Optional<List<PostmanItem>> items) {
        this.items = items;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[name: ").append(this.name);
        if (this.items.isPresent()) {
            sb.append(this.items.toString());
        } else {
            sb.append(", request: ").append(this.request.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public String convert() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.parent.isPresent() ? "# " : "\tScenario: ");
        sb.append(this.name).append(System.lineSeparator());
        if (this.items.isPresent()) {
            for (PostmanItem item : this.items.get()) {
                sb.append(item.convert());
            }
        } else {
            RequestBuilder builder = new RequestBuilder();
            sb.append(builder.addUrl(this.request.getUrl()).addHeaders(this.request.getHeaders()).addBody(this.request.getBody()).addMethod(this.request.getMethod()).build());
        }
        return sb.toString();
    }
}

