/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.job.ChunkResult;
import java.util.ArrayList;
import java.util.List;

public class FeatureScenarios {
    private final ExecutionContext exec;
    public final List<Scenario> scenarios;
    public final List<ChunkResult> chunks;
    private final Runnable onComplete;

    public FeatureScenarios(ExecutionContext exec, List<Scenario> scenarios, Runnable onComplete) {
        this.exec = exec;
        this.scenarios = scenarios;
        this.chunks = new ArrayList<ChunkResult>(scenarios.size());
        this.onComplete = onComplete;
    }

    public boolean isComplete() {
        if (!this.scenarios.isEmpty()) {
            return false;
        }
        for (ChunkResult cr : this.chunks) {
            if (cr.getResult() != null) continue;
            return false;
        }
        return true;
    }

    public void onComplete() {
        for (ChunkResult chunk : this.chunks) {
            this.exec.result.addResult(chunk.getResult());
        }
        this.onComplete.run();
    }

    public String toString() {
        return this.exec.featureContext.feature.toString() + " (" + this.chunks.size() + "/" + (this.scenarios.size() + this.chunks.size()) + ")";
    }
}

