/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.netty.FeatureServer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangedWatcher {
    private static final Logger logger = LoggerFactory.getLogger(FileChangedWatcher.class);
    private final List<File> files;
    private FeatureServer server;
    private final Integer port;
    private final boolean ssl;
    private final File cert;
    private final File key;

    public FileChangedWatcher(File mock, FeatureServer server, Integer port, boolean ssl, File cert, File key) {
        this(Arrays.asList(mock), server, port, ssl, cert, key);
    }

    public FileChangedWatcher(List<File> mocks, FeatureServer server, Integer port, boolean ssl, File cert, File key) {
        this.files = mocks;
        this.server = server;
        this.port = port;
        this.ssl = ssl;
        this.cert = cert;
        this.key = key;
    }

    public void watch() throws InterruptedException, IOException {
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            for (File file2 : this.files) {
                Path directoryPath = file2.toPath().getParent();
                directoryPath.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            while (true) {
                WatchKey wk = watchService.take();
                for (WatchEvent<?> event : wk.pollEvents()) {
                    Path fileChangedPath = (Path)event.context();
                    if (!this.files.stream().anyMatch(file -> fileChangedPath.endsWith(file.getName()))) continue;
                    this.onModified();
                }
                wk.reset();
            }
        }
        catch (Exception e) {
            logger.error("exception when handling change of mock file: {}", (Object)e.getMessage());
            return;
        }
    }

    public void onModified() {
        if (this.server != null) {
            this.server.stop();
            this.server = FeatureServer.start(this.files, (int)this.port, this.ssl, this.cert, this.key, null);
        }
    }
}

