/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.netty.WebSocketListener;
import io.netty.karate.buffer.ByteBuf;
import io.netty.karate.channel.Channel;
import io.netty.karate.channel.ChannelFuture;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.channel.ChannelPromise;
import io.netty.karate.channel.SimpleChannelInboundHandler;
import io.netty.karate.handler.codec.http.FullHttpResponse;
import io.netty.karate.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.karate.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.karate.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.karate.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.karate.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.karate.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.karate.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.karate.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketListener listener;
    private ChannelPromise handshakeFuture;

    public WebSocketClientHandler(WebSocketClientHandshaker handshaker, WebSocketListener listener) {
        this.handshaker = handshaker;
        this.listener = listener;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        logger.debug("websocket client disconnected");
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            try {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                logger.debug("websocket client connected");
                this.handshakeFuture.setSuccess();
            }
            catch (WebSocketHandshakeException e) {
                logger.debug("websocket client connect failed: {}", (Object)e.getMessage());
                this.handshakeFuture.setFailure(e);
            }
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new IllegalStateException("unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof TextWebSocketFrame) {
            if (logger.isTraceEnabled()) {
                logger.trace("websocket received text");
            }
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            this.listener.onMessage(textFrame.text());
        } else if (frame instanceof PongWebSocketFrame) {
            if (logger.isTraceEnabled()) {
                logger.trace("websocket received pong");
            }
        } else if (frame instanceof CloseWebSocketFrame) {
            logger.debug("websocket closing");
            ch.close();
        } else if (frame instanceof BinaryWebSocketFrame) {
            logger.debug("websocket received binary");
            BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
            ByteBuf buf = binaryFrame.content();
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            this.listener.onMessage(bytes);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause.getMessage() != null) {
            logger.error("websocket exception: {}", (Object)cause.getMessage());
        } else {
            cause.printStackTrace();
        }
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }
}

