/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.shell;

import com.intuit.karate.FileUtils;
import com.intuit.karate.LogAppender;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLogAppender
implements LogAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLogAppender.class);
    private final RandomAccessFile file;
    private final FileChannel channel;
    private int prevPos;
    private boolean closed;

    public FileLogAppender(File in) {
        try {
            if (in == null) {
                in = File.createTempFile("karate", "tmp");
            } else if (!in.getParentFile().exists()) {
                in.getParentFile().mkdirs();
            }
            this.file = new RandomAccessFile(in, "rw");
            this.channel = this.file.getChannel();
            this.prevPos = (int)this.channel.position();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getBuffer(boolean resetAndClear) {
        try {
            int pos = (int)this.channel.position();
            ByteBuffer buf = ByteBuffer.allocate(pos - this.prevPos);
            this.channel.read(buf, this.prevPos);
            if (resetAndClear) {
                this.prevPos = pos;
            }
            ((Buffer)buf).flip();
            return FileUtils.toString(buf.array());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getBuffer() {
        return this.getBuffer(false);
    }

    @Override
    public String collect() {
        return this.getBuffer(true);
    }

    @Override
    public void append(String text) {
        if (this.closed) {
            return;
        }
        try {
            this.channel.write(ByteBuffer.wrap(text.getBytes(FileUtils.UTF8)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.file.close();
            this.closed = true;
        }
        catch (Exception e) {
            LOGGER.warn("log appender close failed: {}", (Object)e.getMessage());
        }
    }
}

