/*
 * Decompiled with CFR 0.152.
 */
package io.netty.karate.handler.ipfilter;

import io.netty.karate.channel.ChannelHandler;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.handler.ipfilter.AbstractRemoteAddressFilter;
import io.netty.karate.handler.ipfilter.IpFilterRule;
import io.netty.karate.handler.ipfilter.IpFilterRuleType;
import io.netty.karate.util.internal.ObjectUtil;
import java.net.InetSocketAddress;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        this.rules = ObjectUtil.checkNotNull(rules, "rules");
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (rule == null) break;
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

