/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.karate.message.internal;

import java.text.ParseException;
import java.util.Locale;
import javax.inject.Singleton;
import org.glassfish.jersey.karate.internal.LocalizationMessages;
import org.glassfish.jersey.karate.message.internal.LanguageTag;
import org.glassfish.jersey.karate.message.internal.Utils;
import org.glassfish.jersey.karate.spi.HeaderDelegateProvider;

@Singleton
public class LocaleProvider
implements HeaderDelegateProvider<Locale> {
    @Override
    public boolean supports(Class<?> type) {
        return Locale.class.isAssignableFrom(type);
    }

    public String toString(Locale header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.LOCALE_IS_NULL());
        if (header.getCountry().length() == 0) {
            return header.getLanguage();
        }
        return header.getLanguage() + '-' + header.getCountry();
    }

    public Locale fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.LOCALE_IS_NULL());
        try {
            LanguageTag lt = new LanguageTag(header);
            return lt.getAsLocale();
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing date '" + header + "'", ex);
        }
    }
}

