/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.karate.message.internal;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Singleton;
import org.glassfish.jersey.karate.internal.LocalizationMessages;
import org.glassfish.jersey.karate.message.internal.Utils;
import org.glassfish.jersey.karate.spi.HeaderDelegateProvider;

@Singleton
public class UriProvider
implements HeaderDelegateProvider<URI> {
    @Override
    public boolean supports(Class<?> type) {
        return type == URI.class;
    }

    public String toString(URI header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.URI_IS_NULL());
        return header.toASCIIString();
    }

    public URI fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.URI_IS_NULL());
        try {
            return new URI(header);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error parsing uri '" + header + "'", e);
        }
    }
}

