/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.oauth2.http;

import com.intuit.oauth2.config.ProxyConfig;
import com.intuit.oauth2.data.OAuthMigrationRequest;
import com.intuit.oauth2.exception.InvalidRequestException;
import com.intuit.oauth2.http.MethodType;
import com.intuit.oauth2.http.Request;
import com.intuit.oauth2.http.Response;
import com.intuit.oauth2.utils.LoggerImpl;
import com.intuit.oauth2.utils.PropertiesConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;

public class HttpRequestClient {
    private final CloseableHttpClient client;
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 30000;
    private static final Logger logger = LoggerImpl.getInstance();

    public HttpRequestClient(ProxyConfig proxyConfig) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30000).build();
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("Accept-Encoding", "utf-8"));
        headers.add(new BasicHeader("Accept", "application/json"));
        headers.add(new BasicHeader("User-Agent", "V3JavaSDK-OAuth2-" + PropertiesConfig.getInstance().getProperty("version")));
        HttpClientBuilder hcBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setDefaultRequestConfig(config).setDefaultHeaders(headers).setMaxConnPerRoute(10).setDefaultCredentialsProvider(this.setProxyAuthentication(proxyConfig));
        HttpHost proxy = this.getProxy(proxyConfig);
        if (proxy != null) {
            hcBuilder.setDefaultCredentialsProvider(this.setProxyAuthentication(proxyConfig)).setProxy(proxy).setSSLSocketFactory((LayeredConnectionSocketFactory)this.prepareClientSSL());
        }
        this.client = hcBuilder.build();
    }

    public Response makeRequest(Request request) throws InvalidRequestException {
        MethodType method;
        logger.debug("Enter HttpRequestClient::makeRequest");
        RequestBuilder builder = RequestBuilder.create((String)request.getMethod().value()).setUri(request.constructURL().toString()).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setCharset(StandardCharsets.UTF_8);
        if (request.isRequiresAuthentication()) {
            builder.addHeader("Authorization", request.getAuthString());
        }
        if ((method = request.getMethod()) == MethodType.POST) {
            builder.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            for (NameValuePair nvp : request.getPostParams()) {
                builder.addParameter(nvp);
            }
        }
        logger.debug("Request URI : " + builder.getUri());
        logger.debug("Http Method : " + builder.getMethod());
        try {
            CloseableHttpResponse response = this.client.execute(builder.build());
            return new Response(response.getEntity() == null ? null : response.getEntity().getContent(), response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            logger.error("Exception while making httpRequest", (Throwable)e);
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public Response makeJsonRequest(Request request, OAuthMigrationRequest migrationRequest) throws InvalidRequestException {
        logger.debug("Enter HttpRequestClient::makeJsonRequest");
        CommonsHttpOAuthConsumer consumer = new CommonsHttpOAuthConsumer(migrationRequest.getConsumerKey(), migrationRequest.getConsumerSecret());
        consumer.setTokenWithSecret(migrationRequest.getAccessToken(), migrationRequest.getAccessSecret());
        HttpPost post = new HttpPost(request.constructURL().toString());
        try {
            consumer.sign((Object)post);
        }
        catch (OAuthMessageSignerException e) {
            logger.error("Exception while making httpRequest", (Throwable)e);
            throw new InvalidRequestException(e.getMessage());
        }
        catch (OAuthExpectationFailedException e) {
            logger.error("Exception while making httpRequest", (Throwable)e);
            throw new InvalidRequestException(e.getMessage());
        }
        catch (OAuthCommunicationException e) {
            logger.error("Exception while making httpRequest", (Throwable)e);
            throw new InvalidRequestException(e.getMessage());
        }
        post.setHeader("Accept", "application/json");
        post.setHeader("Content-Type", "application/json");
        StringEntity entity = new StringEntity(request.getPostJson(), "UTF-8");
        post.setEntity((HttpEntity)entity);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.client.execute((HttpUriRequest)post);
            return new Response(httpResponse.getEntity() == null ? null : httpResponse.getEntity().getContent(), httpResponse.getStatusLine().getStatusCode());
        }
        catch (ClientProtocolException e) {
            logger.error("Exception while making httpRequest", (Throwable)e);
            throw new InvalidRequestException(e.getMessage());
        }
        catch (IOException e) {
            logger.error("Exception while making httpRequest", (Throwable)e);
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public CredentialsProvider setProxyAuthentication(ProxyConfig proxyConfig) {
        if (proxyConfig == null) {
            return null;
        }
        String username = proxyConfig.getUsername();
        String password = proxyConfig.getPassword();
        if (!username.isEmpty() && !password.isEmpty()) {
            String host = proxyConfig.getHost();
            String port = proxyConfig.getPort();
            if (!host.isEmpty() && !port.isEmpty()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(host, Integer.parseInt(port)), (Credentials)new UsernamePasswordCredentials(username, password));
                return credentialsProvider;
            }
        }
        return null;
    }

    public SSLConnectionSocketFactory prepareClientSSL() {
        try {
            KeyStore trustStore = null;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext.getSocketFactory(), (HostnameVerifier)new NoopHostnameVerifier());
            return sslConnectionFactory;
        }
        catch (Exception ex) {
            logger.error("couldn't create httpClient!! {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    public HttpHost getProxy(ProxyConfig proxyConfig) {
        if (proxyConfig == null) {
            return null;
        }
        String host = proxyConfig.getHost();
        String port = proxyConfig.getPort();
        HttpHost proxy = null;
        if (!host.isEmpty() && !port.isEmpty()) {
            proxy = new HttpHost(host, Integer.parseInt(port));
        }
        return proxy;
    }
}

